"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRuleFlyoutHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHeaderText = createMode => createMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.search.queryRulesetDetail.queryRuleFlyoutTitle.create",
  defaultMessage: "Create rule"
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.search.queryRulesetDetail.queryRuleFlyoutTitle.edit",
  defaultMessage: "Edit rule"
});
const QueryRuleFlyoutHeader = ({
  createMode,
  ruleId
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "data-test-subj": "queryRulesFlyoutHeader"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    id: "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, getHeaderText(createMode)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Rule ID: {ruleId}",
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.ruleId",
    values: {
      ruleId
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "The unique identifier of the query rule within the specified ruleset to retrieve",
      id: "xpack.search.queryRulesetDetail.queryRuleFlyout.ruleIdTooltip"
    }),
    position: "right"
  }))))));
};
exports.QueryRuleFlyoutHeader = QueryRuleFlyoutHeader;