"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchPreview = exports.fetchSearchResults = exports.DEFAULT_SEARCH_PREVIEW_DATA = void 0;
var _reactQuery = require("@kbn/react-query");
var _reactHookForm = require("react-hook-form");
var _types = require("../types");
var _use_kibana = require("./use_kibana");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SEARCH_PREVIEW_DATA = exports.DEFAULT_SEARCH_PREVIEW_DATA = {
  results: [],
  pagination: _common.DEFAULT_PAGINATION
};
const fetchSearchResults = async ({
  query,
  indices,
  elasticsearchQuery,
  pagination: paginationParam = _common.DEFAULT_PAGINATION,
  http
}) => {
  const {
    results,
    pagination: paginationResult
  } = await http.post(_types.APIRoutes.POST_SEARCH_QUERY, {
    body: JSON.stringify({
      search_query: query,
      elasticsearch_query: JSON.stringify(elasticsearchQuery),
      indices,
      size: paginationParam.size,
      from: paginationParam.from
    })
  });
  return {
    results,
    pagination: paginationResult
  };
};
exports.fetchSearchResults = fetchSearchResults;
const useSearchPreview = ({
  query,
  pagination
}) => {
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const {
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const indices = getValues(_types.ChatFormFields.indices);
  const elasticsearchQuery = getValues(_types.ChatFormFields.elasticsearchQuery);
  const {
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['search-preview-results', query, indices, elasticsearchQuery, pagination],
    queryFn: () => fetchSearchResults({
      query,
      pagination,
      http,
      indices,
      elasticsearchQuery
    }),
    initialData: DEFAULT_SEARCH_PREVIEW_DATA,
    enabled: !!query,
    refetchOnWindowFocus: false,
    refetchOnReconnect: false,
    refetchOnMount: false
  });
  return {
    pagination: data.pagination,
    results: data.results
  };
};
exports.useSearchPreview = useSearchPreview;