"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadConnectors = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("@kbn/triggers-actions-ui-plugin/public/common/constants");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/stack-connectors-plugin/public/common");
var _inferenceCommon = require("@kbn/inference-common");
var _inferenceEndpointUiCommon = require("@kbn/inference-endpoint-ui-common");
var _use_kibana = require("./use_kibana");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_KEY = ['search-playground, load-connectors'];
const connectorTypeToLLM = [{
  actionId: _common.OPENAI_CONNECTOR_ID,
  actionProvider: _common.OpenAiProviderType.AzureAi,
  match: connector => {
    var _config;
    return connector.actionTypeId === _common.OPENAI_CONNECTOR_ID && (connector === null || connector === void 0 ? void 0 : (_config = connector.config) === null || _config === void 0 ? void 0 : _config.apiProvider) === _common.OpenAiProviderType.AzureAi;
  },
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.openAIAzureConnectorTitle', {
      defaultMessage: 'OpenAI Azure'
    }),
    type: _types.LLMs.openai_azure
  })
}, {
  actionId: _common.OPENAI_CONNECTOR_ID,
  match: connector => {
    var _config2;
    return connector.actionTypeId === _common.OPENAI_CONNECTOR_ID && ((connector === null || connector === void 0 ? void 0 : (_config2 = connector.config) === null || _config2 === void 0 ? void 0 : _config2.apiProvider) === _common.OpenAiProviderType.OpenAi || !!connector.isPreconfigured);
  },
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.openAIConnectorTitle', {
      defaultMessage: 'OpenAI'
    }),
    type: _types.LLMs.openai
  })
}, {
  actionId: _common.OPENAI_CONNECTOR_ID,
  actionProvider: _common.OpenAiProviderType.Other,
  match: connector => {
    var _config3;
    return connector.actionTypeId === _common.OPENAI_CONNECTOR_ID && (connector === null || connector === void 0 ? void 0 : (_config3 = connector.config) === null || _config3 === void 0 ? void 0 : _config3.apiProvider) === _common.OpenAiProviderType.Other;
  },
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.openAIOtherConnectorTitle', {
      defaultMessage: 'OpenAI Other'
    }),
    type: _types.LLMs.openai_other
  })
}, {
  actionId: _common.BEDROCK_CONNECTOR_ID,
  match: connector => connector.actionTypeId === _common.BEDROCK_CONNECTOR_ID,
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.bedrockConnectorTitle', {
      defaultMessage: 'Bedrock'
    }),
    type: _types.LLMs.bedrock
  })
}, {
  actionId: _common.GEMINI_CONNECTOR_ID,
  match: connector => connector.actionTypeId === _common.GEMINI_CONNECTOR_ID,
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.geminiConnectorTitle', {
      defaultMessage: 'Gemini'
    }),
    type: _types.LLMs.gemini
  })
}, {
  actionId: _common.INFERENCE_CONNECTOR_ID,
  match: connector => connector.actionTypeId === _common.INFERENCE_CONNECTOR_ID && (0, _inferenceCommon.isSupportedConnector)(connector),
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.aiConnectorTitle', {
      defaultMessage: 'AI Connector'
    }),
    type: _types.LLMs.inference
  })
}];
const useLoadConnectors = () => {
  const {
    services: {
      http,
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _reactQuery.useQuery)(QUERY_KEY, async () => {
    const queryResult = await (0, _constants.loadAllActions)({
      http
    });
    return queryResult.reduce(async (result, connector) => {
      var _config4;
      const {
        transform
      } = connectorTypeToLLM.find(({
        match
      }) => match(connector)) || {};
      if (!connector.isMissingSecrets && !!transform && (connector.actionTypeId !== '.inference' || connector.actionTypeId === '.inference' && (await (0, _inferenceEndpointUiCommon.isInferenceEndpointExists)(http, connector === null || connector === void 0 ? void 0 : (_config4 = connector.config) === null || _config4 === void 0 ? void 0 : _config4.inferenceId)))) {
        return [...(await result), transform(connector)];
      }
      return result;
    }, Promise.resolve([]));
  }, {
    retry: false,
    keepPreviousData: true,
    onError: error => {
      if (error.name !== 'AbortError') {
        var _notifications$toasts;
        notifications === null || notifications === void 0 ? void 0 : (_notifications$toasts = notifications.toasts) === null || _notifications$toasts === void 0 ? void 0 : _notifications$toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: _i18n.i18n.translate('xpack.searchPlayground.loadConnectorsError', {
            defaultMessage: 'Error loading connectors. Please check your configuration and try again.'
          })
        });
      }
    }
  });
};
exports.useLoadConnectors = useLoadConnectors;