"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectLLMButton = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/actions-plugin/common");
var _use_kibana = require("../../hooks/use_kibana");
var _use_load_connectors = require("../../hooks/use_load_connectors");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectLLMButton = () => {
  const [connectorFlyoutOpen, setConnectorFlyoutOpen] = (0, _react.useState)(false);
  const [showCallout, setShowAddedCallout] = (0, _react.useState)(false);
  const {
    services: {
      triggersActionsUi: {
        getAddConnectorFlyout: ConnectorFlyout
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    data: connectors,
    refetch: refetchConnectors
  } = (0, _use_load_connectors.useLoadConnectors)();
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const handleConnectorCreated = () => {
    refetchConnectors();
    setShowAddedCallout(true);
    setConnectorFlyoutOpen(false);
  };
  const handleSetupGenAiConnector = () => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.genAiConnectorCreated);
    setConnectorFlyoutOpen(true);
  };
  (0, _react.useEffect)(() => {
    if (connectors !== null && connectors !== void 0 && connectors.length) {
      if (showCallout) {
        usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.genAiConnectorAdded);
      } else {
        usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.genAiConnectorExists);
      }
    } else {
      usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.genAiConnectorSetup);
    }
  }, [connectors === null || connectors === void 0 ? void 0 : connectors.length, showCallout, usageTracker]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, connectors !== null && connectors !== void 0 && connectors.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "check",
    color: "success",
    onClick: handleSetupGenAiConnector,
    "data-test-subj": "successConnectLLMButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.setupPage.llmConnectedButtonLabel",
    defaultMessage: "LLM connected"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "link",
    "data-test-subj": "connectLLMButton",
    onClick: handleSetupGenAiConnector
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.setupPage.connectLLMButtonLabel",
    defaultMessage: "Connect to an LLM"
  })), connectorFlyoutOpen && /*#__PURE__*/_react.default.createElement(ConnectorFlyout, {
    featureId: _common.GenerativeAIForSearchPlaygroundConnectorFeatureId,
    onConnectorCreated: handleConnectorCreated,
    onClose: () => setConnectorFlyoutOpen(false)
  }));
};
exports.ConnectLLMButton = ConnectLLMButton;