"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectIndicesFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _create_query = require("../utils/create_query");
var _use_indices_fields = require("../hooks/use_indices_fields");
var _use_source_indices_field = require("../hooks/use_source_indices_field");
var _use_query_indices = require("../hooks/use_query_indices");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectIndicesFlyout = ({
  onClose
}) => {
  const [query, setQuery] = (0, _react.useState)('');
  const {
    indices,
    isLoading: isIndicesLoading
  } = (0, _use_query_indices.useQueryIndices)(query);
  const {
    indices: selectedIndices,
    setIndices: setSelectedIndices
  } = (0, _use_source_indices_field.useSourceIndicesFields)();
  const [selectedTempIndices, setSelectedTempIndices] = (0, _react.useState)(selectedIndices);
  const handleSelectOptions = options => {
    setSelectedTempIndices(options.filter(option => option.checked === 'on').map(option => option.label));
  };
  const handleSearchChange = searchValue => {
    setQuery(searchValue);
  };
  const handleSaveQuery = () => {
    setSelectedIndices(selectedTempIndices);
    onClose();
  };
  const tabs = [{
    id: 'indices',
    name: _i18n.i18n.translate('xpack.searchPlayground.setupPage.addDataSource.flyout.tabName', {
      defaultMessage: 'Indices'
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
      searchable: true,
      searchProps: {
        onChange: handleSearchChange
      },
      options: [{
        label: _i18n.i18n.translate('xpack.searchPlayground.setupPage.addDataSource.flyout.groupOption', {
          defaultMessage: 'Available indices'
        }),
        isGroupLabel: true
      }, ...indices.map((index, num) => ({
        label: index,
        checked: selectedTempIndices.includes(index) ? 'on' : '',
        'data-test-subj': `sourceIndex-${num}`
      }))],
      onChange: handleSelectOptions,
      listProps: {
        showIcons: true,
        bordered: false
      },
      isLoading: isIndicesLoading,
      renderOption: undefined
    }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list)))
  }];
  const {
    fields,
    isLoading: isFieldsLoading
  } = (0, _use_indices_fields.useIndicesFields)(selectedTempIndices);
  const noSourceFieldsWarning = (0, _create_query.getIndicesWithNoSourceFields)(fields);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "s",
    ownFocus: true,
    onClose: onClose,
    "data-test-subj": "selectIndicesFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.addDataSource.flyout.title",
    defaultMessage: "Add data to query"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    autoFocus: "selected",
    "data-test-subj": "indicesTable"
  }), !isFieldsLoading && !!noSourceFieldsWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    "data-test-subj": "NoIndicesFieldsMessage"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.addDataSource.flyout.warningCallout",
    defaultMessage: "No fields found for {errorMessage}. Try adding data to these indices.",
    values: {
      errorMessage: noSourceFieldsWarning
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left",
    "data-test-subj": "closeButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.addDataSource.flyout.closeButton",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleSaveQuery,
    "data-test-subj": "saveButton",
    fill: true,
    disabled: !selectedTempIndices.length
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.setupPage.addDataSource.flyout.saveButton",
    defaultMessage: "Save and continue"
  }))))));
};
exports.SelectIndicesFlyout = SelectIndicesFlyout;