"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupAISearchButton = exports.QuickStats = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mappings_convertor = require("./mappings_convertor");
var _quick_stat = require("./quick_stat");
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SetupAISearchButton = () => {
  const {
    services: {
      docLinks
    }
  } = (0, _use_kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    color: "transparent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h6", null, _i18n.i18n.translate('xpack.searchIndices.quickStats.setup_ai_search_description', {
    defaultMessage: 'Build AI-powered search experiences with Elastic'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: docLinks.links.enterpriseSearch.semanticSearch,
    target: "_blank",
    "data-test-subj": "setupAISearchButton"
  }, _i18n.i18n.translate('xpack.searchIndices.quickStats.setup_ai_search_button', {
    defaultMessage: 'Set up now'
  })))));
};
exports.SetupAISearchButton = SetupAISearchButton;
const QuickStats = ({
  index,
  mappings,
  indexDocuments
}) => {
  var _indexDocuments$resul, _index$size;
  const [open, setOpen] = (0, _react.useState)(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const mappingStats = (0, _react.useMemo)(() => (0, _mappings_convertor.countVectorBasedTypesFromMappings)(mappings), [mappings]);
  const vectorFieldCount = mappingStats.sparse_vector + mappingStats.dense_vector + mappingStats.semantic_text;
  const docCount = (_indexDocuments$resul = indexDocuments === null || indexDocuments === void 0 ? void 0 : indexDocuments.results._meta.page.total) !== null && _indexDocuments$resul !== void 0 ? _indexDocuments$resul : 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    "data-test-subj": "quickStats",
    hasShadow: false,
    css: () => ({
      border: euiTheme.border.thin,
      background: euiTheme.colors.lightestShade,
      overflow: 'hidden'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_quick_stat.QuickStat, {
    open: open,
    setOpen: setOpen,
    icon: "documents",
    iconColor: euiTheme.colors.fullShade,
    title: _i18n.i18n.translate('xpack.searchIndices.quickStats.document_count_heading', {
      defaultMessage: 'Document count'
    }),
    "data-test-subj": "QuickStatsDocumentCount",
    secondaryTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
      value: docCount !== null && docCount !== void 0 ? docCount : 0
    }),
    stats: [{
      title: _i18n.i18n.translate('xpack.searchIndices.quickStats.documents.totalTitle', {
        defaultMessage: 'Total'
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: docCount !== null && docCount !== void 0 ? docCount : 0
      })
    }, {
      title: _i18n.i18n.translate('xpack.searchIndices.quickStats.documents.indexSize', {
        defaultMessage: 'Index Size'
      }),
      description: (_index$size = index.size) !== null && _index$size !== void 0 ? _index$size : '0b'
    }],
    first: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_quick_stat.QuickStat, {
    open: open,
    setOpen: setOpen,
    icon: "sparkles",
    iconColor: euiTheme.colors.fullShade,
    title: _i18n.i18n.translate('xpack.searchIndices.quickStats.ai_search_heading', {
      defaultMessage: 'AI Search'
    }),
    "data-test-subj": "QuickStatsAIMappings",
    secondaryTitle: vectorFieldCount > 0 ? _i18n.i18n.translate('xpack.searchIndices.quickStats.total_count', {
      defaultMessage: '{value, plural, one {# Field} other {# Fields}}',
      values: {
        value: vectorFieldCount
      }
    }) : _i18n.i18n.translate('xpack.searchIndices.quickStats.no_vector_fields', {
      defaultMessage: 'Not configured'
    }),
    content: vectorFieldCount === 0 && /*#__PURE__*/_react.default.createElement(SetupAISearchButton, null),
    stats: [{
      title: _i18n.i18n.translate('xpack.searchIndices.quickStats.sparse_vector', {
        defaultMessage: 'Sparse Vector'
      }),
      description: _i18n.i18n.translate('xpack.searchIndices.quickStats.sparse_vector_count', {
        defaultMessage: '{value, plural, one {# Field} other {# Fields}}',
        values: {
          value: mappingStats.sparse_vector
        }
      })
    }, {
      title: _i18n.i18n.translate('xpack.searchIndices.quickStats.dense_vector', {
        defaultMessage: 'Dense Vector'
      }),
      description: _i18n.i18n.translate('xpack.searchIndices.quickStats.dense_vector_count', {
        defaultMessage: '{value, plural, one {# Field} other {# Fields}}',
        values: {
          value: mappingStats.dense_vector
        }
      })
    }, {
      title: _i18n.i18n.translate('xpack.searchIndices.quickStats.semantic_text', {
        defaultMessage: 'Semantic Text'
      }),
      description: _i18n.i18n.translate('xpack.searchIndices.quickStats.semantic_text_count', {
        defaultMessage: '{value, plural, one {# Field} other {# Fields}}',
        values: {
          value: mappingStats.semantic_text
        }
      })
    }]
  }))));
};
exports.QuickStats = QuickStats;