"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _result_metadata = require("./result/result_metadata");
var _ = require("..");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentList = ({
  dataTelemetryIdPrefix,
  docs,
  docsPerPage,
  isLoading,
  mappings,
  meta,
  onPaginate,
  setDocsPerPage,
  onDocumentClick,
  resultProps = {}
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const getIconType = size => {
    return size === docsPerPage ? 'check' : 'empty';
  };
  const pageCount = meta !== null && meta !== void 0 && meta.pageSize ? Math.ceil(meta.totalItemCount / (meta === null || meta === void 0 ? void 0 : meta.pageSize)) : 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('searchIndexDocuments.documentList.paginationAriaLabel', {
      defaultMessage: 'Pagination for document list'
    }),
    pageCount: pageCount,
    activePage: meta.pageIndex,
    onPageClick: onPaginate
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "searchIndexDocuments.documentList.description",
    defaultMessage: "Showing {results} of {total}. Search results maxed at {maximum} documents.",
    values: {
      maximum: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: 10000
      }),
      results: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: docs.length
      })),
      total: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: meta.totalItemCount
      }))
    }
  }))), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), docs.map(doc => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: doc._id
    }, /*#__PURE__*/_react.default.createElement(_.Result, (0, _extends2.default)({
      fields: (0, _result_metadata.resultToFieldFromMappingResponse)(doc, mappings),
      metaData: (0, _result_metadata.resultMetaData)(doc),
      onDocumentClick: onDocumentClick ? () => onDocumentClick(doc) : undefined
    }, resultProps)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('searchIndexDocuments.documentList.paginationAriaLabel', {
      defaultMessage: 'Pagination for document list'
    }),
    pageCount: pageCount,
    activePage: meta.pageIndex,
    onPageClick: onPaginate
  })), setDocsPerPage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "aria-label": _i18n.i18n.translate('searchIndexDocuments.documentList.docsPerPage', {
      defaultMessage: 'Document count per page dropdown'
    }),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-telemetry-id": `${dataTelemetryIdPrefix}-documents-docsPerPage`,
      size: "s",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: () => {
        setIsPopoverOpen(true);
      }
    }, _i18n.i18n.translate('searchIndexDocuments.documentList.pagination.itemsPerPage', {
      defaultMessage: 'Documents per page: {docPerPage}',
      values: {
        docPerPage: docsPerPage
      }
    })),
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(false);
    },
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "10 rows",
      icon: getIconType(10),
      onClick: () => {
        setIsPopoverOpen(false);
        setDocsPerPage(10);
      }
    }, _i18n.i18n.translate('searchIndexDocuments.documentList.paginationOptions.option', {
      defaultMessage: '{docCount} documents',
      values: {
        docCount: 10
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "25 rows",
      icon: getIconType(25),
      onClick: () => {
        setIsPopoverOpen(false);
        setDocsPerPage(25);
      }
    }, _i18n.i18n.translate('searchIndexDocuments.documentList.paginationOptions.option', {
      defaultMessage: '{docCount} documents',
      values: {
        docCount: 25
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "50 rows",
      icon: getIconType(50),
      onClick: () => {
        setIsPopoverOpen(false);
        setDocsPerPage(50);
      }
    }, _i18n.i18n.translate('searchIndexDocuments.documentList.paginationOptions.option', {
      defaultMessage: '{docCount} documents',
      values: {
        docCount: 50
      }
    }))]
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), meta.totalItemCount > 9999 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "searchIndexDocuments.documentList.resultLimitTitle",
      defaultMessage: "Results are limited to {number} documents",
      values: {
        number: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
          value: 10000
        })
      }
    }),
    iconType: "search"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "searchIndexDocuments.documentList.resultLimit",
    defaultMessage: "Only the first {number} results are available for paging. Please use the search bar to filter down your results.",
    values: {
      number: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: 10000
      })
    }
  }))));
};
exports.DocumentList = DocumentList;