"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectTaggingOssPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class SavedObjectTaggingOssPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "apiRegistered", false);
    (0, _defineProperty2.default)(this, "api", void 0);
  }
  setup({}) {
    return {
      registerTaggingApi: provider => {
        if (this.apiRegistered) {
          throw new Error('tagging API can only be registered once');
        }
        this.apiRegistered = true;
        provider.then(api => {
          this.api = api;
        }, error => {
          // eslint-disable-next-line no-console
          console.log('Error during tagging API promise resolution. SO tagging has been disabled', error);
          this.apiRegistered = false;
        });
      }
    };
  }
  start({}) {
    return {
      isTaggingAvailable: () => this.apiRegistered,
      getTaggingApi: () => this.api
    };
  }
}
exports.SavedObjectTaggingOssPlugin = SavedObjectTaggingOssPlugin;