"use strict";

/*
 * This file is forked from the lodash project (https://lodash.com/),
 * and may include modifications made by Elasticsearch B.V.
 * Elasticsearch B.V. licenses this file to you under the MIT License.
 * See `src/platform/packages/shared/kbn-safer-lodash-set/LICENSE` for more information.
 */

/* eslint-disable one-var,prettier/prettier,no-var,eqeqeq,no-nested-ternary */

var assignValue = require('lodash/_assignValue'),
  castPath = require('lodash/_castPath'),
  isFunction = require('lodash/isFunction'),
  isIndex = require('lodash/_isIndex'),
  isObject = require('lodash/isObject'),
  toKey = require('lodash/_toKey');

/**
 * The base implementation of `_.set`.
 *
 * @internal
 * @param {Object} object The object to modify.
 * @param {Array|string} path The path of the property to set.
 * @param {*} value The value to set.
 * @param {Function} [customizer] The function to customize path creation.
 * @returns {Object} Returns `object`.
 */
function baseSet(object, path, value, customizer) {
  if (!isObject(object)) {
    return object;
  }
  path = castPath(path, object);
  var index = -1,
    length = path.length,
    lastIndex = length - 1,
    nested = object;
  while (nested != null && ++index < length) {
    var key = toKey(path[index]),
      newValue = value;
    if (key == 'prototype' && isFunction(nested)) {
      throw new Error('Illegal access of function prototype');
    }
    if (index != lastIndex) {
      var objValue = hasOwnProperty.call(nested, key) ? nested[key] : undefined;
      newValue = customizer ? customizer(objValue, key, nested) : undefined;
      if (newValue === undefined) {
        newValue = isObject(objValue) ? objValue : isIndex(path[index + 1]) ? [] : {};
      }
    }
    assignValue(nested, key, newValue);
    nested = nested[key];
  }
  return object;
}
module.exports = baseSet;