"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateRollupDelay = validateRollupDelay;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  InvalidEsIntervalFormatError,
  InvalidEsCalendarIntervalError,
  parseEsInterval
} = _public.search.aggs;
function validateRollupDelay(rollupDelay) {
  // This field is optional, so if nothing has been provided we can skip validation.
  if (!rollupDelay || !rollupDelay.trim()) {
    return undefined;
  }
  try {
    parseEsInterval(rollupDelay);
  } catch (error) {
    if (error instanceof InvalidEsIntervalFormatError) {
      return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.errors.rollupDelayInvalidFormat",
        defaultMessage: "Invalid delay format."
      })];
    }
    if (error instanceof InvalidEsCalendarIntervalError) {
      const {
        unit
      } = error;
      return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.errors.rollupDelayInvalidCalendarInterval",
        defaultMessage: "The ''{unit}'' unit only allows values of 1. Try {suggestion}.",
        values: {
          unit,
          suggestion: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.rollupJobs.create.errors.rollupDelayInvalidCalendarIntervalSuggestion",
            defaultMessage: "1{unit}",
            values: {
              unit
            }
          }))
        }
      })];
    }
    throw error;
  }
  return undefined;
}