"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentVersionInfo = getAgentVersionInfo;
exports.getLatestAgentVersionForPattern = getLatestAgentVersionForPattern;
var _semver = _interopRequireDefault(require("semver"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAgentVersionInfo(fleetStart, kibanaVersion, versionPattern) {
  // If undefined, we will follow fleet's strategy to select latest available version:
  // for serverless we will use the latest published version, for statefull we will use
  // current Kibana version. If false, irrespective of fleet flags and logic, we are
  // explicitly deciding to not append the current version.
  const includeCurrentVersion = kibanaVersion.endsWith('-SNAPSHOT') ? false : undefined;
  const agentClient = fleetStart.agentService.asInternalUser;
  const [agentVersion, agentBaseVersion, agentDockerImageVersion] = await Promise.all([agentClient.getLatestAgentAvailableVersion(includeCurrentVersion), agentClient.getLatestAgentAvailableBaseVersion(includeCurrentVersion), agentClient.getLatestAgentAvailableDockerImageVersion(includeCurrentVersion)]);
  const agentTargetVersion = versionPattern ? getLatestAgentVersionForPattern(await agentClient.getAvailableVersions(), kibanaVersion, versionPattern) : undefined;
  return {
    agentVersion,
    agentBaseVersion,
    agentDockerImageVersion,
    agentTargetVersion
  };
}
function getLatestAgentVersionForPattern(agentVersionList, kibanaVersion, versionPattern) {
  var _agentVersionList$fin;
  return (_agentVersionList$fin = agentVersionList.find(version => {
    return _semver.default.satisfies(version, versionPattern);
  })) !== null && _agentVersionList$fin !== void 0 ? _agentVersionList$fin : kibanaVersion;
}