"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccordionWithIcon = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AccordionWithIcon = ({
  title,
  icon,
  borders = 'horizontal',
  children,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, (0, _extends2.default)({}, rest, {
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false,
      css: {
        marginLeft: 8
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      css: rest.isDisabled ? {
        color: 'inherit'
      } : undefined
    }, /*#__PURE__*/_react.default.createElement("h3", null, title)))),
    buttonProps: {
      paddingSize: 'l'
    },
    borders: borders,
    paddingSize: "none"
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: {
      paddingLeft: 36,
      paddingBottom: 24
    }
  }, children));
};
exports.AccordionWithIcon = AccordionWithIcon;