"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomHeader = CustomHeader;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _back_button = require("../shared/back_button");
var _logo_icon = require("../shared/logo_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CustomHeader({
  euiIconType,
  logo,
  headlineCopy,
  captionCopy,
  isTechnicalPreview = false
}) {
  const theme = (0, _eui.useEuiTheme)();
  const shadow = (0, _eui.useEuiShadow)('s');
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPageTemplate.Section, {
    css: (0, _react.css)`
        border-bottom: ${theme.euiTheme.border.thin};
      `,
    grow: false,
    paddingSize: "l",
    restrictWidth: true
  }, /*#__PURE__*/_react2.default.createElement(_back_button.BackButton, null, _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.button.returnButtonLabel', {
    defaultMessage: 'Return'
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
              border-radius: ${theme.euiTheme.border.radius.medium};
              ${shadow}
            `
  }, /*#__PURE__*/_react2.default.createElement(_logo_icon.LogoIcon, {
    euiIconType: euiIconType,
    isAvatar: !!euiIconType,
    logo: logo,
    size: "xxl",
    css: (0, _react.css)`
                margin: 12px;
                width: 56px;
                height: 56px;
              `
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "m"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react2.default.createElement("h1", null, headlineCopy)), isTechnicalPreview && /*#__PURE__*/_react2.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.techPreviewBadge.label', {
      defaultMessage: 'Technical preview'
    }),
    size: "m",
    color: "hollow",
    tooltipContent: _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.techPreviewBadge.tooltip', {
      defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
    }),
    tooltipPosition: 'right'
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react2.default.createElement("p", null, captionCopy)))));
}