"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityLogsExplorerPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _use_kibana = require("../utils/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ObservabilityLogsExplorerPageTemplate = ({
  pageSectionProps,
  ...props
}) => {
  const {
    services: {
      observabilityShared
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  return /*#__PURE__*/_react2.default.createElement(observabilityShared.navigation.PageTemplate, (0, _extends2.default)({
    pageSectionProps: {
      ...defaultPageSectionProps,
      ...pageSectionProps
    }
  }, props));
};
exports.ObservabilityLogsExplorerPageTemplate = ObservabilityLogsExplorerPageTemplate;
const fullHeightContentStyles = (0, _react.css)`
  display: flex;
  flex-direction: column;
  flex: 1 0 auto;
  width: 100%;
  height: 100%;
`;
const defaultPageSectionProps = {
  grow: true,
  paddingSize: 'none',
  contentProps: {
    css: fullHeightContentStyles
  }
};