"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsExplorerTopNavMenu = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _public = require("@kbn/observability-shared-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _uiTheme = require("@kbn/ui-theme");
var _public2 = require("@kbn/discover-plugin/public");
var _react2 = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _translations = require("../../common/translations");
var _use_kibana = require("../utils/use_kibana");
var _discover_link = require("./discover_link");
var _feedback_link = require("./feedback_link");
var _onboarding_link = require("./onboarding_link");
var _alerts_popover = require("./alerts_popover");
var _dataset_quality_link = require("./dataset_quality_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsExplorerTopNavMenu = () => {
  const {
    services: {
      chrome
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const chromeStyle = (0, _useObservable.default)(chrome.getChromeStyle$());
  return chromeStyle === 'project' ? /*#__PURE__*/_react2.default.createElement(ProjectTopNav, null) : /*#__PURE__*/_react2.default.createElement(ClassicTopNav, null);
};
exports.LogsExplorerTopNavMenu = LogsExplorerTopNavMenu;
const ProjectTopNav = () => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiHeader, {
    "data-test-subj": "logsExplorerHeaderMenu",
    css: {
      boxShadow: 'none',
      backgroundColor: _uiTheme.euiThemeVars.euiPageBackgroundColor
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSection, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react2.default.createElement(_public2.LogsExplorerTabs, {
    services: services,
    selectedTab: "logs-explorer"
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSection, {
    side: "right",
    css: (0, _react.css)`
          gap: ${_uiTheme.euiThemeVars.euiSizeM};
        `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react2.default.createElement(DeprecationNoticeBadge, null)), /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_discover_link.ConnectedDiscoverLink, null), /*#__PURE__*/_react2.default.createElement(ConditionalVerticalRule, {
    Component: (0, _dataset_quality_link.ConnectedDatasetQualityLink)()
  }), /*#__PURE__*/_react2.default.createElement(VerticalRule, null), /*#__PURE__*/_react2.default.createElement(_feedback_link.FeedbackLink, null), /*#__PURE__*/_react2.default.createElement(VerticalRule, null), /*#__PURE__*/_react2.default.createElement(_alerts_popover.AlertsPopover, null), /*#__PURE__*/_react2.default.createElement(VerticalRule, null))), /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react2.default.createElement(_onboarding_link.ConnectedOnboardingLink, null))));
};
const ClassicTopNav = () => {
  const {
    services: {
      appParams: {
        setHeaderActionMenu
      },
      chrome,
      i18n: i18nStart,
      theme
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  /**
   * Since the breadcrumbsAppendExtension might be set only during a plugin start (e.g. search session)
   * we retrieve the latest valid extension in order to restore it once we unmount the beta badge.
   */
  const [previousAppendExtension$] = (0, _react2.useState)(() => chrome.getBreadcrumbsAppendExtension$().pipe((0, _rxjs.filter)(Boolean), (0, _rxjs.take)(1)));
  const previousAppendExtension = (0, _useObservable.default)(previousAppendExtension$);
  (0, _react2.useEffect)(() => {
    if (chrome) {
      chrome.setBreadcrumbsAppendExtension({
        content: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSection, {
          "data-test-subj": "logsExplorerHeaderMenu",
          css: (0, _react.css)`
              margin-left: ${_uiTheme.euiThemeVars.euiSizeM};
            `
        }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react2.default.createElement(_feedback_link.FeedbackLink, null))), {
          theme,
          i18n: i18nStart
        })
      });
    }
    return () => {
      if (chrome) {
        chrome.setBreadcrumbsAppendExtension(previousAppendExtension);
      }
    };
  }, [chrome, i18nStart, previousAppendExtension, theme]);
  return /*#__PURE__*/_react2.default.createElement(_public.HeaderMenuPortal, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme.theme$
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSection, {
    "data-test-subj": "logsExplorerHeaderMenu"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react2.default.createElement(DeprecationNoticeBadge, null)), /*#__PURE__*/_react2.default.createElement(_discover_link.ConnectedDiscoverLink, null), /*#__PURE__*/_react2.default.createElement(ConditionalVerticalRule, {
    Component: (0, _dataset_quality_link.ConnectedDatasetQualityLink)()
  }), /*#__PURE__*/_react2.default.createElement(VerticalRule, null), /*#__PURE__*/_react2.default.createElement(_alerts_popover.AlertsPopover, null), /*#__PURE__*/_react2.default.createElement(VerticalRule, null), /*#__PURE__*/_react2.default.createElement(_onboarding_link.ConnectedOnboardingLink, null)))));
};
const VerticalRule = _styled.default.span`
  width: 1px;
  height: 20px;
  background-color: ${_uiTheme.euiThemeVars.euiColorLightShade};
`;
const ConditionalVerticalRule = ({
  Component
}) => Component && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(VerticalRule, null), Component);
const DeprecationNoticeBadge = () => /*#__PURE__*/_react2.default.createElement(_eui.EuiBetaBadge, {
  label: _translations.deprecationBadgeTitle,
  color: "subdued",
  tooltipContent: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, _translations.deprecationBadgeDescription, /*#__PURE__*/_react2.default.createElement("br", null), /*#__PURE__*/_react2.default.createElement("br", null), _translations.deprecationBadgeGuideline),
  alignment: "middle"
});