"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateExistingIndexAssets = updateExistingIndexAssets;
var _common = require("../../../common");
var _create_or_update_conversation_index_assets = require("./create_or_update_conversation_index_assets");
var _create_or_update_knowledge_base_index_assets = require("./create_or_update_knowledge_base_index_assets");
var _has_kb_index = require("../knowledge_base_service/has_kb_index");
var _get_inference_id_from_write_index = require("../knowledge_base_service/get_inference_id_from_write_index");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function updateExistingIndexAssets({
  logger,
  core
}) {
  const [coreStart] = await core.getStartServices();
  const esClient = coreStart.elasticsearch.client;
  const doesKbIndexExist = await (0, _has_kb_index.hasKbWriteIndex)({
    esClient
  });
  const doesConversationIndexExist = await esClient.asInternalUser.indices.exists({
    index: _.resourceNames.writeIndexAlias.conversations
  });
  if (!doesKbIndexExist && !doesConversationIndexExist) {
    logger.debug('Index assets do not exist. Aborting updating index assets');
    return;
  }
  if (doesConversationIndexExist) {
    logger.debug('Found index for conversations. Updating index assets.');
    await (0, _create_or_update_conversation_index_assets.createOrUpdateConversationIndexAssets)({
      logger,
      core
    });
  }
  if (doesKbIndexExist) {
    logger.debug('Found index for knowledge base. Updating index assets.');
    const currentInferenceId = await (0, _get_inference_id_from_write_index.getInferenceIdFromWriteIndex)(esClient).catch(() => {
      logger.debug(`Current KB write index does not have an inference_id. This is to be expected for indices created before 8.16`);
      return _common.ELSER_ON_ML_NODE_INFERENCE_ID;
    });
    await (0, _create_or_update_knowledge_base_index_assets.createOrUpdateKnowledgeBaseIndexAssets)({
      logger,
      core,
      inferenceId: currentInferenceId
    });
  }
}