"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.concatenateChatCompletionChunks = void 0;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _conversation_complete = require("../conversation_complete");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const concatenateChatCompletionChunks = () => source => source.pipe((0, _rxjs.filter)(event => event.type === _conversation_complete.StreamingChatResponseEventType.ChatCompletionChunk), (0, _rxjs.scan)((acc, {
  message
}) => {
  var _message$content, _message$function_cal, _message$function_cal2, _message$function_cal3, _message$function_cal4;
  acc.message.content += (_message$content = message.content) !== null && _message$content !== void 0 ? _message$content : '';
  acc.message.function_call.name += (_message$function_cal = (_message$function_cal2 = message.function_call) === null || _message$function_cal2 === void 0 ? void 0 : _message$function_cal2.name) !== null && _message$function_cal !== void 0 ? _message$function_cal : '';
  acc.message.function_call.arguments += (_message$function_cal3 = (_message$function_cal4 = message.function_call) === null || _message$function_cal4 === void 0 ? void 0 : _message$function_cal4.arguments) !== null && _message$function_cal3 !== void 0 ? _message$function_cal3 : '';
  return (0, _lodash.cloneDeep)(acc);
}, {
  message: {
    content: '',
    function_call: {
      name: '',
      arguments: '',
      trigger: _types.MessageRole.Assistant
    },
    role: _types.MessageRole.Assistant
  }
}), (0, _rxjs.defaultIfEmpty)({
  message: {
    content: '',
    function_call: {
      name: '',
      arguments: '',
      trigger: _types.MessageRole.Assistant
    },
    role: _types.MessageRole.Assistant
  }
}));
exports.concatenateChatCompletionChunks = concatenateChatCompletionChunks;