"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KnowledgeBaseTab = KnowledgeBaseTab;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _hooks = require("@kbn/ai-assistant/src/hooks");
var _knowledge_base_installation_status_panel = require("@kbn/ai-assistant/src/knowledge_base/knowledge_base_installation_status_panel");
var _setting_up_knowledge_base = require("@kbn/ai-assistant/src/knowledge_base/setting_up_knowledge_base");
var _inspect_knowlegde_base_popover = require("@kbn/ai-assistant/src/knowledge_base/inspect_knowlegde_base_popover");
var _knowledge_base_reindexing_callout = require("@kbn/ai-assistant/src/knowledge_base/knowledge_base_reindexing_callout");
var _use_get_knowledge_base_entries = require("../../hooks/use_get_knowledge_base_entries");
var _categorize_entries = require("../../helpers/categorize_entries");
var _knowledge_base_edit_manual_entry_flyout = require("./knowledge_base_edit_manual_entry_flyout");
var _knowledge_base_category_flyout = require("./knowledge_base_category_flyout");
var _knowledge_base_bulk_import_flyout = require("./knowledge_base_bulk_import_flyout");
var _use_kibana = require("../../hooks/use_kibana");
var _knowledge_base_edit_user_instruction_flyout = require("./knowledge_base_edit_user_instruction_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fullHeightClassName = (0, _css.css)`
  height: 100%;
`;
const centerMaxWidthClassName = (0, _css.css)`
  text-align: center;
`;
const panelClassname = (0, _css.css)`
  width: 100%;
`;
function KnowledgeBaseTab() {
  var _knowledgeBase$status, _knowledgeBase$status2;
  const {
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const dateFormat = uiSettings.get('dateFormat');
  const knowledgeBase = (0, _hooks.useKnowledgeBase)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const columns = [{
    align: 'right',
    width: '40px',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.span.expandRowLabel', {
      defaultMessage: 'Expand row'
    }))),
    render: category => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "pluginsColumnsButton",
        onClick: () => setSelectedCategory(category),
        "aria-label": category.categoryKey === (selectedCategory === null || selectedCategory === void 0 ? void 0 : selectedCategory.categoryKey) ? 'Collapse' : 'Expand',
        iconType: category.categoryKey === (selectedCategory === null || selectedCategory === void 0 ? void 0 : selectedCategory.categoryKey) ? 'minimize' : 'expand'
      });
    }
  }, {
    field: '',
    name: '',
    render: category => {
      if (category.entries.length === 1 && category.entries[0].role === 'user_entry') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "documentation",
          color: "primary"
        });
      }
      if (category.entries.length === 1 && category.entries[0].role === 'assistant_summarization') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "sparkles",
          color: "primary"
        });
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "logoElastic"
      });
    },
    width: '40px'
  }, {
    'data-test-subj': 'knowledgeBaseTableTitleCell',
    field: 'title',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.name', {
      defaultMessage: 'Name'
    }),
    sortable: true
  }, {
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.numberOfEntries', {
      defaultMessage: 'Number of entries'
    }),
    width: '140px',
    render: category => {
      if (category.entries.length > 1 && category.entries[0].role === 'elastic') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, category.entries.length);
      }
      return null;
    }
  }, {
    'data-test-subj': 'knowledgeBaseTableAuthorCell',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.author', {
      defaultMessage: 'Author'
    }),
    width: '140px',
    render: category => {
      var _category$entries$, _category$entries$$us;
      return (_category$entries$ = category.entries[0]) === null || _category$entries$ === void 0 ? void 0 : (_category$entries$$us = _category$entries$.user) === null || _category$entries$$us === void 0 ? void 0 : _category$entries$$us.name;
    }
  }, {
    field: '@timestamp',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.dateCreated', {
      defaultMessage: 'Date created'
    }),
    width: '140px',
    sortable: true,
    render: timestamp => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, (0, _moment.default)(timestamp).format(dateFormat))
  }, {
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.type', {
      defaultMessage: 'Type'
    }),
    width: '140px',
    render: category => {
      if (category.entries.length === 1 && category.entries[0].role === 'user_entry') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow"
        }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.manualBadgeLabel', {
          defaultMessage: 'Manual'
        }));
      }
      if (category.entries.length === 1 && category.entries[0].role === 'assistant_summarization') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow"
        }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.assistantSummarization', {
          defaultMessage: 'Assistant'
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.columns.systemBadgeLabel', {
        defaultMessage: 'System'
      }));
    }
  }];
  const [selectedCategory, setSelectedCategory] = (0, _react.useState)();
  const [newEntryFlyoutType, setNewEntryFlyoutType] = (0, _react.useState)();
  const [isNewEntryPopoverOpen, setIsNewEntryPopoverOpen] = (0, _react.useState)(false);
  const [isEditUserInstructionFlyoutOpen, setIsEditUserInstructionFlyoutOpen] = (0, _react.useState)(false);
  const [query, setQuery] = (0, _react.useState)('');
  const [sortBy, setSortBy] = (0, _react.useState)('title');
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const {
    entries = [],
    isLoading,
    refetch
  } = (0, _use_get_knowledge_base_entries.useGetKnowledgeBaseEntries)({
    query,
    sortBy,
    sortDirection,
    kbState: (_knowledgeBase$status = knowledgeBase.status.value) === null || _knowledgeBase$status === void 0 ? void 0 : _knowledgeBase$status.kbState
  });
  const categorizedEntries = (0, _categorize_entries.categorizeEntries)({
    entries
  });
  const handleChangeSort = ({
    sort
  }) => {
    if (sort) {
      const {
        field,
        direction
      } = sort;
      setSortBy(field);
      setSortDirection(direction);
    }
  };
  const handleChangeQuery = e => {
    setQuery((e === null || e === void 0 ? void 0 : e.currentTarget.value) || '');
  };
  if (knowledgeBase.status.loading && !knowledgeBase.isPolling) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      "data-test-subj": "knowledgeBaseTabLoader"
    })));
  }
  if (((_knowledgeBase$status2 = knowledgeBase.status.value) === null || _knowledgeBase$status2 === void 0 ? void 0 : _knowledgeBase$status2.kbState) === _public.KnowledgeBaseState.READY) {
    var _knowledgeBase$status3;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, ((_knowledgeBase$status3 = knowledgeBase.status.value) === null || _knowledgeBase$status3 === void 0 ? void 0 : _knowledgeBase$status3.isReIndexing) && /*#__PURE__*/_react.default.createElement(_knowledge_base_reindexing_callout.KnowledgeBaseReindexingCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
      "data-test-subj": "knowledgeBaseTabFieldSearch",
      fullWidth: true,
      placeholder: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.euiFieldSearch.searchThisLabel', {
        defaultMessage: 'Search for an entry'
      }),
      value: query,
      onChange: handleChangeQuery,
      isClearable: true,
      "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.euiFieldSearch.searchEntriesLabel', {
        defaultMessage: 'Search entries'
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "knowledgeBaseTabReloadButton",
      color: "success",
      iconType: "refresh",
      onClick: () => refetch()
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.reloadButtonLabel', {
      defaultMessage: 'Reload'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "observabilityAiAssistantManagementKnowledgeBaseTabEditInstructionsButton",
      color: "text",
      onClick: () => setIsEditUserInstructionFlyoutOpen(true)
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.editInstructionsButtonLabel', {
      defaultMessage: 'Edit User-specific Prompt'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      isOpen: isNewEntryPopoverOpen,
      closePopover: () => setIsNewEntryPopoverOpen(false),
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        "data-test-subj": "knowledgeBaseNewEntryButton",
        iconSide: "right",
        iconType: "arrowDown",
        onClick: () => setIsNewEntryPopoverOpen(prevValue => !prevValue)
      }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.newEntryButtonLabel', {
        defaultMessage: 'New entry'
      }))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "singleEntry",
        icon: "document",
        "data-test-subj": "knowledgeBaseSingleEntryContextMenuItem",
        onClick: () => {
          setIsNewEntryPopoverOpen(false);
          setNewEntryFlyoutType('singleEntry');
        },
        size: "s"
      }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.singleEntryContextMenuItemLabel', {
        defaultMessage: 'Single entry'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "bulkImport",
        icon: "documents",
        "data-test-subj": "knowledgeBaseBulkImportContextMenuItem",
        onClick: () => {
          setIsNewEntryPopoverOpen(false);
          setNewEntryFlyoutType('bulkImport');
        }
      }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.bulkImportContextMenuItemLabel', {
        defaultMessage: 'Bulk import'
      }))]
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      "data-test-subj": "knowledgeBaseTable",
      columns: columns,
      items: categorizedEntries,
      loading: isLoading,
      sorting: {
        sort: {
          field: sortBy,
          direction: sortDirection
        }
      },
      rowProps: row => ({
        onClick: () => setSelectedCategory(row)
      }),
      onChange: handleChangeSort
    }))), isEditUserInstructionFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_knowledge_base_edit_user_instruction_flyout.KnowledgeBaseEditUserInstructionFlyout, {
      onClose: () => setIsEditUserInstructionFlyoutOpen(false)
    }) : null, newEntryFlyoutType === 'singleEntry' ? /*#__PURE__*/_react.default.createElement(_knowledge_base_edit_manual_entry_flyout.KnowledgeBaseEditManualEntryFlyout, {
      onClose: () => setNewEntryFlyoutType(undefined)
    }) : null, newEntryFlyoutType === 'bulkImport' ? /*#__PURE__*/_react.default.createElement(_knowledge_base_bulk_import_flyout.KnowledgeBaseBulkImportFlyout, {
      onClose: () => setNewEntryFlyoutType(undefined)
    }) : null, selectedCategory ? selectedCategory.entries.length === 1 && (selectedCategory.entries[0].role === 'user_entry' || selectedCategory.entries[0].role === 'assistant_summarization') ? /*#__PURE__*/_react.default.createElement(_knowledge_base_edit_manual_entry_flyout.KnowledgeBaseEditManualEntryFlyout, {
      entry: selectedCategory.entries[0],
      onClose: () => {
        setSelectedCategory(undefined);
        refetch();
      }
    }) : /*#__PURE__*/_react.default.createElement(_knowledge_base_category_flyout.KnowledgeBaseCategoryFlyout, {
      category: selectedCategory,
      onClose: () => setSelectedCategory(undefined)
    }) : null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "column",
    gutterSize: "none",
    className: fullHeightClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    css: (0, _css.css)`
          line-height: ${euiTheme.size.l};
        `
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.description', {
    defaultMessage: 'Knowledge Base is a feature that enables the AI Assistant to recall multiple knowledge sources: documents, organizational resources like runbooks, GitHub issues, and internal documentation. It improves response quality with added context for more tailored assistance. '
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "observabilityAiAssistantManagementKnowledgeBaseTabLearnMoreLink",
    href: "https://www.elastic.co/docs/solutions/observability/observability-ai-assistant#obs-ai-add-data",
    target: "_blank"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.learnMoreLink', {
    defaultMessage: 'Learn More'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "xl",
    grow: false,
    className: panelClassname
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: centerMaxWidthClassName
  }, knowledgeBase.isInstalling ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_setting_up_knowledge_base.SettingUpKnowledgeBase, null), /*#__PURE__*/_react.default.createElement(_inspect_knowlegde_base_popover.InspectKnowledgeBasePopover, {
    knowledgeBase: knowledgeBase
  })) : /*#__PURE__*/_react.default.createElement(_knowledge_base_installation_status_panel.KnowledgeBaseInstallationStatusPanel, {
    knowledgeBase: knowledgeBase
  }))));
}