"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-ai-assistant-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const uiSettings = exports.uiSettings = {
  [_common.aiAssistantSimulatedFunctionCalling]: {
    category: ['observability'],
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.simulatedFunctionCallingLabel', {
      defaultMessage: 'Simulate function calling'
    }),
    value: false,
    description: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.simulatedFunctionCallingDescription', {
      defaultMessage: '<em>[technical preview]</em> Simulated function calling does not need API support for functions or tools, but it may decrease performance. It is currently always enabled for connectors that do not have API support for Native function calling, regardless of this setting.',
      values: {
        em: chunks => `<em>${chunks}</em>`
      }
    }),
    schema: _configSchema.schema.boolean(),
    type: 'boolean',
    requiresPageReload: true,
    solution: 'oblt'
  },
  [_common.aiAssistantSearchConnectorIndexPattern]: {
    category: ['observability'],
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsTab.h3.searchConnectorIndexPatternLabel', {
      defaultMessage: 'Search connector index pattern'
    }),
    value: '',
    description: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.searchConnectorIndexPatternDescription', {
      defaultMessage: 'Index pattern used by the AI Assistant when querying search connectors indices (part of the knowledge base). By default the index for every search connector will be queried'
    }),
    schema: _configSchema.schema.string(),
    type: 'string',
    requiresPageReload: true,
    solution: 'oblt'
  }
};