"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ObsAIAssistantParamsFields = ({
  errors,
  index,
  messageVariables,
  editAction,
  actionParams,
  service
}) => {
  var _errors$connector, _errors$message;
  const {
    connectors,
    loading,
    selectConnector,
    selectedConnector
  } = (0, _public.useGenAIConnectorsWithoutContext)(service);
  (0, _react.useEffect)(() => {
    editAction('connector', selectedConnector, index);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedConnector, index]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.observabilityAiAssistant.alertConnector.selectLlmConnector', {
      defaultMessage: 'Connector'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "observabilityAiAssistantAlertConnectorSelect",
    isLoading: loading
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: ((_errors$connector = errors.connector) === null || _errors$connector === void 0 ? void 0 : _errors$connector.length) > 0,
    options: connectors === null || connectors === void 0 ? void 0 : connectors.map(connector => {
      return {
        value: connector.id,
        text: connector.name
      };
    }),
    onChange: event => {
      selectConnector(event.target.value);
      editAction('connector', event.target.value, index);
    },
    value: selectedConnector
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.observabilityAiAssistant.alertConnector.messageTextAreaFieldLabel', {
      defaultMessage: 'Message'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    fullWidth: true,
    "data-test-subj": "observabilityAiAssistantAlertConnectorMessageTextArea",
    value: actionParams.message,
    onChange: event => {
      editAction('message', event.target.value, index);
    }
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: ((_errors$message = errors.message) === null || _errors$message === void 0 ? void 0 : _errors$message.length) > 0
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.default = ObsAIAssistantParamsFields;
module.exports = exports.default;