"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CollapsibleStatement = CollapsibleStatement;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
require("./collapsible_statement.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getToggleIconType(isCollapsed) {
  return isCollapsed ? 'arrowRight' : 'arrowDown';
}
function CollapsibleStatement(props) {
  const {
    collapse,
    expand,
    id,
    isCollapsed
  } = props;
  const toggleClicked = () => {
    if (isCollapsed) {
      expand(id);
    } else {
      collapse(id);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    alignItems: "center",
    className: "monPipelineViewer__collapsibleStatement"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: id,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": "collapse",
    color: "text",
    iconType: getToggleIconType(isCollapsed),
    onClick: toggleClicked,
    size: "s"
  })), props.children);
}
CollapsibleStatement.propTypes = {
  collapse: _propTypes.default.func.isRequired,
  expand: _propTypes.default.func.isRequired,
  id: _propTypes.default.string.isRequired,
  isCollapsed: _propTypes.default.bool.isRequired
};