"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCharts = useCharts;
var _moment = _interopRequireDefault(require("moment"));
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_monitoring_time = require("./use_monitoring_time");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCharts() {
  const {
    services
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    handleTimeChange
  } = (0, _use_monitoring_time.useMonitoringTimeContainerContext)();
  const [zoomInLevel, setZoomInLevel] = (0, _react.useState)(0);

  // We need something to know when the onBrush event was fired because the pop state event
  // is also fired when the onBrush event is fired (although only on the first onBrush event) and
  // causing the zoomInLevel to change.
  // In Angular, this was handled by removing the listener before updating the state and adding
  // it again after some milliseconds, but the same trick didn't work in React.
  const [onBrushHappened, _setOnBrushHappened] = (0, _react.useState)(false);
  const onBrushHappenedRef = (0, _react.useRef)(onBrushHappened);
  const setOnBrushHappened = data => {
    onBrushHappenedRef.current = data;
    _setOnBrushHappened(data);
  };
  (0, _react.useEffect)(() => {
    const popstateHandler = () => {
      if (onBrushHappenedRef.current) {
        setOnBrushHappened(false);
      } else {
        setZoomInLevel(currentZoomInLevel => {
          if (currentZoomInLevel > 0) {
            return currentZoomInLevel - 1;
          }
          return 0;
        });
      }
    };
    window.addEventListener('popstate', popstateHandler);
    return () => window.removeEventListener('popstate', popstateHandler);
  }, []);
  const onBrush = ({
    xaxis
  }) => {
    var _services$uiSettings;
    const {
      to,
      from
    } = xaxis;
    const timezone = (_services$uiSettings = services.uiSettings) === null || _services$uiSettings === void 0 ? void 0 : _services$uiSettings.get('dateFormat:tz');
    const offset = getOffsetInMS(timezone);
    const fromTime = (0, _moment.default)(from - offset);
    const toTime = (0, _moment.default)(to - offset);
    handleTimeChange(fromTime.toISOString(), toTime.toISOString());
    setOnBrushHappened(true);
    setZoomInLevel(zoomInLevel + 1);
  };
  const zoomInfo = {
    zoomOutHandler: () => history.goBack(),
    showZoomOutBtn: () => zoomInLevel > 0
  };
  return {
    onBrush,
    zoomInfo
  };
}
const getOffsetInMS = timezone => {
  if (timezone === 'Browser') {
    return 0;
  }
  const offsetInMinutes = _moment.default.tz(timezone).utcOffset();
  const offsetInMS = offsetInMinutes * 1 * 60 * 1000;
  return offsetInMS;
};