"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerLanguage = registerLanguage;
exports.registerTheme = registerTheme;
var _monaco_imports = require("./monaco_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function registerLanguage(language) {
  const {
    ID,
    lexerRules,
    languageConfiguration,
    foldingRangeProvider
  } = language;
  _monaco_imports.monaco.languages.register({
    id: ID
  });
  if ('languageThemeResolver' in language) {
    _monaco_imports.monaco.editor.registerLanguageThemeResolver(ID, language.languageThemeResolver);
  }
  _monaco_imports.monaco.languages.onLanguage(ID, async () => {
    if (lexerRules) {
      _monaco_imports.monaco.languages.setMonarchTokensProvider(ID, lexerRules);
    }
    if (languageConfiguration) {
      _monaco_imports.monaco.languages.setLanguageConfiguration(ID, languageConfiguration);
    }
    if (foldingRangeProvider) {
      _monaco_imports.monaco.languages.registerFoldingRangeProvider(ID, foldingRangeProvider);
    }
    if ('onLanguage' in language) {
      await language.onLanguage();
    }
  });
}

/**
 *
 * @deprecated avoid using this function, use `monaco.editor.registerLanguageThemeDefinition` instead
 */
function registerTheme(id, themeData) {
  try {
    _monaco_imports.monaco.editor.defineTheme(id, themeData);
  } catch (e) {
    // nothing to be here
  }
}