"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notificationsRouteFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _locator = require("../../../locator");
var _router = require("../router");
var _use_resolver = require("../use_resolver");
var _ml_nodes_check = require("../../ml_nodes_check");
var _ml_server_info = require("../../services/ml_server_info");
var _breadcrumbs = require("../breadcrumbs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NotificationsPage = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../notifications/page'))));
const notificationsRouteFactory = (navigateToPath, basePath) => ({
  id: 'notifications',
  path: (0, _router.createPath)(_locator.ML_PAGES.NOTIFICATIONS),
  title: _i18n.i18n.translate('xpack.ml.notifications.notificationsLabel', {
    defaultMessage: 'Notifications'
  }),
  enableDatePicker: true,
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, null),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.overview.notificationsLabel', {
      defaultMessage: 'Notifications'
    })
  }],
  'data-test-subj': 'mlPageNotifications'
});
exports.notificationsRouteFactory = notificationsRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetMlInfo'], {
    getMlNodeCount: _ml_nodes_check.getMlNodeCount,
    loadMlServerInfo: _ml_server_info.loadMlServerInfo
  });
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null
  }, /*#__PURE__*/_react.default.createElement(NotificationsPage, null)));
};