"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WizardSteps = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlFieldStatsFlyout = require("@kbn/ml-field-stats-flyout");
var _job_creator_context = require("../components/job_creator_context");
var _kibana = require("../../../../contexts/kibana");
var _step_types = require("../components/step_types");
var _time_range_step = require("../components/time_range_step");
var _pick_fields_step = require("../components/pick_fields_step");
var _job_details_step = require("../components/job_details_step");
var _validation_step = require("../components/validation_step");
var _summary_step = require("../components/summary_step");
var _datafeed_step = require("../components/datafeed_step");
var _ml = require("../../../../contexts/ml");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WizardSteps = ({
  currentStep,
  setCurrentStep
}) => {
  const dataSourceContext = (0, _ml.useDataSource)();
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const fieldStatsServices = (0, _react.useMemo)(() => {
    const {
      uiSettings,
      data,
      fieldFormats,
      charts
    } = services;
    return {
      uiSettings,
      dataViews: data.dataViews,
      data,
      fieldFormats,
      charts
    };
  }, [services]);
  const {
    jobCreator,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [start, setStart] = (0, _react.useState)(jobCreator === null || jobCreator === void 0 ? void 0 : jobCreator.start);
  const [end, setEnd] = (0, _react.useState)(jobCreator === null || jobCreator === void 0 ? void 0 : jobCreator.end);
  (0, _react.useEffect)(() => {
    if (jobCreator && jobCreator.start !== start || jobCreator.end !== end) {
      setStart(jobCreator.start);
      setEnd(jobCreator.end);
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);

  // Format timestamp to ISO formatted date strings
  const timeRangeMs = (0, _react.useMemo)(() => {
    // If time range is available via jobCreator, use that
    // else mimic Discover and set timeRange to be now for data view without time field
    return start && end ? {
      from: start,
      to: end
    } : undefined;
  }, [start, end]);

  // store whether the advanced and additional sections have been expanded.
  // has to be stored at this level to ensure it's remembered on wizard step change
  const [advancedExpanded, setAdvancedExpanded] = (0, _react.useState)(false);
  const [additionalExpanded, setAdditionalExpanded] = (0, _react.useState)(false);
  function getSummaryStepTitle() {
    if (dataSourceContext.selectedSavedSearch) {
      var _dataSourceContext$se;
      return _i18n.i18n.translate('xpack.ml.newJob.wizard.stepComponentWrapper.summaryTitleSavedSearch', {
        defaultMessage: 'New job from saved Discover session {title}',
        values: {
          title: (_dataSourceContext$se = dataSourceContext.selectedSavedSearch.title) !== null && _dataSourceContext$se !== void 0 ? _dataSourceContext$se : ''
        }
      });
    } else if (dataSourceContext.selectedDataView.id !== undefined) {
      return _i18n.i18n.translate('xpack.ml.newJob.wizard.stepComponentWrapper.summaryTitleDataView', {
        defaultMessage: 'New job from data view {dataViewName}',
        values: {
          dataViewName: dataSourceContext.selectedDataView.getName()
        }
      });
    }
    return '';
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, currentStep === _step_types.WIZARD_STEPS.TIME_RANGE && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(Title, {
    "data-test-subj": "mlJobWizardStepTitleTimeRange"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.stepComponentWrapper.timeRangeTitle",
    defaultMessage: "Time range"
  })), /*#__PURE__*/_react.default.createElement(_time_range_step.TimeRangeStep, {
    isCurrentStep: currentStep === _step_types.WIZARD_STEPS.TIME_RANGE,
    setCurrentStep: setCurrentStep
  })), currentStep === _step_types.WIZARD_STEPS.ADVANCED_CONFIGURE_DATAFEED && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(Title, {
    "data-test-subj": "mlJobWizardStepTitleConfigureDatafeed"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.stepComponentWrapper.configureDatafeedTitle",
    defaultMessage: "Configure datafeed"
  })), /*#__PURE__*/_react.default.createElement(_datafeed_step.DatafeedStep, {
    isCurrentStep: currentStep === _step_types.WIZARD_STEPS.ADVANCED_CONFIGURE_DATAFEED,
    setCurrentStep: setCurrentStep
  })), currentStep === _step_types.WIZARD_STEPS.PICK_FIELDS && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.FieldStatsFlyoutProvider, {
    dataView: dataSourceContext.selectedDataView,
    fieldStatsServices: fieldStatsServices,
    timeRangeMs: timeRangeMs,
    dslQuery: jobCreator.query,
    theme: services.theme
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(Title, {
    "data-test-subj": "mlJobWizardStepTitlePickFields"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.stepComponentWrapper.pickFieldsTitle",
    defaultMessage: "Choose fields"
  })))), /*#__PURE__*/_react.default.createElement(_pick_fields_step.PickFieldsStep, {
    isCurrentStep: currentStep === _step_types.WIZARD_STEPS.PICK_FIELDS,
    setCurrentStep: setCurrentStep
  })))), currentStep === _step_types.WIZARD_STEPS.JOB_DETAILS && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(Title, {
    "data-test-subj": "mlJobWizardStepTitleJobDetails"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.stepComponentWrapper.jobDetailsTitle",
    defaultMessage: "Job details"
  })), /*#__PURE__*/_react.default.createElement(_job_details_step.JobDetailsStep, {
    isCurrentStep: currentStep === _step_types.WIZARD_STEPS.JOB_DETAILS,
    setCurrentStep: setCurrentStep,
    advancedExpanded: advancedExpanded,
    setAdvancedExpanded: setAdvancedExpanded,
    additionalExpanded: additionalExpanded,
    setAdditionalExpanded: setAdditionalExpanded
  })), currentStep === _step_types.WIZARD_STEPS.VALIDATION && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(Title, {
    "data-test-subj": "mlJobWizardStepTitleValidation"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.stepComponentWrapper.validationTitle",
    defaultMessage: "Validation"
  })), /*#__PURE__*/_react.default.createElement(_validation_step.ValidationStep, {
    isCurrentStep: currentStep === _step_types.WIZARD_STEPS.VALIDATION,
    setCurrentStep: setCurrentStep
  })), currentStep === _step_types.WIZARD_STEPS.SUMMARY && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(Title, {
    "data-test-subj": "mlJobWizardStepTitleSummary"
  }, getSummaryStepTitle()), /*#__PURE__*/_react.default.createElement(_summary_step.SummaryStep, {
    isCurrentStep: currentStep === _step_types.WIZARD_STEPS.SUMMARY,
    setCurrentStep: setCurrentStep
  })));
};
exports.WizardSteps = WizardSteps;
const Title = ({
  'data-test-subj': dataTestSubj,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": dataTestSubj
  }, children)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};