"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableSectionSplom = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _scatterplot_matrix = require("../../../../../components/scatterplot_matrix");
var _expandable_section = require("./expandable_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpandableSectionSplom = props => {
  const {
    euiTheme: {
      size
    }
  } = (0, _eui.useEuiTheme)();
  const splomSectionHeaderItems = undefined;
  const splomSectionContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "full",
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: {
      padding: `${size.s}`
    }
  }, /*#__PURE__*/_react.default.createElement(_scatterplot_matrix.ScatterplotMatrix, props)));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    dataTestId: "splom",
    urlStateKey: "splom",
    content: splomSectionContent,
    headerItems: splomSectionHeaderItems,
    isExpanded: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.exploration.splomSectionTitle",
      defaultMessage: "Scatterplot matrix"
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.ExpandableSectionSplom = ExpandableSectionSplom;