"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlTelemetryContextProvider = exports.MlTelemetryContext = void 0;
exports.useMlTelemetryClient = useMlTelemetryClient;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MlTelemetryContext = exports.MlTelemetryContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const MlTelemetryContextProvider = ({
  children,
  telemetryClient
}) => {
  return /*#__PURE__*/_react.default.createElement(MlTelemetryContext.Provider, {
    value: {
      telemetryClient
    }
  }, children);
};
exports.MlTelemetryContextProvider = MlTelemetryContextProvider;
function useMlTelemetryClient() {
  const context = (0, _react.useContext)(MlTelemetryContext);
  if (context === undefined) {
    throw new Error('useMlTelemetryClient must be used within a MlTelemetryContextProvider');
  }
  return context;
}