"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartTooltipStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _tool_tip = require("@elastic/eui/lib/components/tool_tip/tool_tip.styles");
var _mlKibanaTheme = require("@kbn/ml-kibana-theme");
var _kibana = require("../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error style types not defined

const useChartTooltipStyles = () => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    services: {
      theme
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme
  } = (0, _mlKibanaTheme.useCurrentEuiThemeVars)(theme);
  const euiStyles = (0, _tool_tip.euiToolTipStyles)(euiThemeContext);
  return {
    mlChartTooltip: (0, _react.css)([euiStyles.euiToolTip, {
      fontSize: euiTheme.euiFontSizeXS,
      padding: 0,
      transition: `opacity ${euiTheme.euiAnimSpeedNormal}`,
      pointerEvents: 'none',
      userSelect: 'none',
      maxWidth: '512px',
      position: 'relative'
    }]),
    mlChartTooltipList: (0, _react.css)({
      margin: euiTheme.euiSizeXS,
      paddingBottom: euiTheme.euiSizeXS
    }),
    mlChartTooltipHeader: (0, _react.css)({
      fontWeight: euiTheme.euiFontWeightBold,
      padding: `${euiTheme.euiSizeXS} ${(0, _eui.mathWithUnits)(euiTheme.euiSizeS, x => x * 2)}`,
      marginBottom: euiTheme.euiSizeXS,
      borderBottom: `1px solid ${(0, _eui.transparentize)(euiTheme.euiBorderColor, 0.8)}`
    }),
    mlChartTooltipItem: (0, _react.css)({
      display: 'flex',
      padding: '3px',
      boxSizing: 'border-box',
      borderLeft: `${euiTheme.euiSizeXS} solid transparent`
    }),
    mlChartTooltipLabel: (0, _react.css)({
      minWidth: '1px'
    }),
    mlChartTooltipValue: (0, _react.css)({
      fontWeight: euiTheme.euiFontWeightBold,
      textAlign: 'right',
      fontFeatureSettings: 'tnum',
      marginLeft: '8px'
    })
  };
};
exports.useChartTooltipStyles = useChartTooltipStyles;