"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsExplorerServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/discover-plugin/common");
var _locators = require("../common/locators");
var _ui_settings = require("../common/ui_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogsExplorerServerPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "locators", void 0);
  }
  setup(core, plugins) {
    const {
      share
    } = plugins;
    core.uiSettings.register(_ui_settings.uiSettings);
    const discoverAppLocator = share.url.locators.get(_common.DISCOVER_APP_LOCATOR);

    // Register Locators
    const logsExplorerLocator = share.url.locators.create(new _locators.LogsExplorerLocatorDefinition({
      discoverAppLocator
    }));
    this.locators = {
      logsExplorerLocator
    };
    return {
      locators: this.locators
    };
  }
  start() {}
}
exports.LogsExplorerServerPlugin = LogsExplorerServerPlugin;