"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntersectionRef = useIntersectionRef;
var _react = require("react");
var _useIntersection = _interopRequireDefault(require("react-use/lib/useIntersection"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useIntersectionRef({
  onIntersecting
} = {}) {
  const [intersectionRef, setRef] = (0, _react.useState)(null);
  const intersection = (0, _useIntersection.default)({
    current: intersectionRef
  }, {
    root: null,
    threshold: 0.5
  });
  (0, _react.useEffect)(() => {
    if (intersection !== null && intersection !== void 0 && intersection.isIntersecting && onIntersecting) {
      onIntersecting();
    }
  }, [intersection, onIntersecting]);
  return [setRef, intersection];
}