"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPublicStateFromContext = exports.getContextFromPublicState = void 0;
var _common = require("../../common");
var _logs_explorer_controller = require("../state_machines/logs_explorer_controller");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPublicStateFromContext = context => {
  return {
    chart: context.chart,
    dataSourceSelection: context.dataSourceSelection.toPlainSelection(),
    grid: context.grid,
    filters: context.filters,
    query: context.query,
    refreshInterval: context.refreshInterval,
    time: context.time,
    controls: getPublicControlsStateFromControlPanels(context.controlPanels)
  };
};
exports.getPublicStateFromContext = getPublicStateFromContext;
const getContextFromPublicState = (publicState, allSelection) => {
  var _publicState$grid, _publicState$filters, _publicState$query, _publicState$refreshI, _publicState$time;
  return {
    ..._logs_explorer_controller.DEFAULT_CONTEXT,
    chart: {
      ..._logs_explorer_controller.DEFAULT_CONTEXT.chart,
      ...publicState.chart
    },
    controlPanels: getControlPanelsFromPublicControlsState(publicState.controls),
    dataSourceSelection: publicState.dataSourceSelection != null ? (0, _common.hydrateDataSourceSelection)(publicState.dataSourceSelection, allSelection) : _logs_explorer_controller.DEFAULT_CONTEXT.dataSourceSelection,
    grid: {
      ..._logs_explorer_controller.DEFAULT_CONTEXT.grid,
      ...publicState.grid,
      rows: {
        ..._logs_explorer_controller.DEFAULT_CONTEXT.grid.rows,
        ...((_publicState$grid = publicState.grid) === null || _publicState$grid === void 0 ? void 0 : _publicState$grid.rows)
      }
    },
    filters: (_publicState$filters = publicState.filters) !== null && _publicState$filters !== void 0 ? _publicState$filters : _logs_explorer_controller.DEFAULT_CONTEXT.filters,
    query: (_publicState$query = publicState.query) !== null && _publicState$query !== void 0 ? _publicState$query : _logs_explorer_controller.DEFAULT_CONTEXT.query,
    refreshInterval: (_publicState$refreshI = publicState.refreshInterval) !== null && _publicState$refreshI !== void 0 ? _publicState$refreshI : _logs_explorer_controller.DEFAULT_CONTEXT.refreshInterval,
    time: (_publicState$time = publicState.time) !== null && _publicState$time !== void 0 ? _publicState$time : _logs_explorer_controller.DEFAULT_CONTEXT.time
  };
};
exports.getContextFromPublicState = getContextFromPublicState;
const getPublicControlsStateFromControlPanels = controlPanels => controlPanels != null ? {
  ...(_common.availableControlsPanels.NAMESPACE in controlPanels ? {
    [_common.availableControlsPanels.NAMESPACE]: getOptionsListPublicControlStateFromControlPanel(controlPanels[_common.availableControlsPanels.NAMESPACE])
  } : {})
} : {};
const getOptionsListPublicControlStateFromControlPanel = optionsListControlPanel => {
  var _optionsListControlPa;
  return {
    mode: optionsListControlPanel.exclude ? 'exclude' : 'include',
    selection: optionsListControlPanel.existsSelected ? {
      type: 'exists'
    } : {
      type: 'options',
      selectedOptions: (_optionsListControlPa = optionsListControlPanel.selectedOptions) !== null && _optionsListControlPa !== void 0 ? _optionsListControlPa : []
    }
  };
};
const getControlPanelsFromPublicControlsState = publicControlsState => {
  if (publicControlsState == null) {
    return {};
  }
  const namespacePublicControlState = publicControlsState[_common.availableControlsPanels.NAMESPACE];
  return {
    ...(namespacePublicControlState ? {
      [_common.availableControlsPanels.NAMESPACE]: getControlPanelFromOptionsListPublicControlState(_common.availableControlsPanels.NAMESPACE, namespacePublicControlState)
    } : {})
  };
};
const getControlPanelFromOptionsListPublicControlState = (controlId, publicControlState) => {
  const defaultControlPanelConfig = _common.controlPanelConfigs[controlId];
  return {
    ...defaultControlPanelConfig,
    exclude: publicControlState.mode === 'exclude',
    ...(publicControlState.selection.type === 'exists' ? {
      existsSelected: true
    } : {
      selectedOptions: publicControlState.selection.selectedOptions
    })
  };
};