"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewsFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logsDataViewType = 'logs';
function getSelectedFilterLabel(dataType) {
  const availableFilters = {
    [logsDataViewType]: _constants.logsDataViewTypeLabel
  };
  return !dataType ? _constants.allDataViewTypesLabel : availableFilters[dataType];
}
const DataViewsFilter = ({
  count,
  filter,
  onFilter
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const closeTypePopover = () => {
    setPopover(false);
  };
  const togglePopover = () => {
    setPopover(!isPopoverOpen);
  };
  const createSelectTypeFilter = dataType => {
    return () => {
      onFilter({
        dataType
      });
      closeTypePopover();
    };
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, _i18n.i18n.translate('xpack.logsExplorer.dataSourceSelector.dataViewCount', {
    defaultMessage: '{count, plural, one {# data view} other {# data views}}',
    values: {
      count
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "logsExplorerDataSourceSelectorDataViewTypeButton",
      iconType: "arrowDown",
      iconSide: "right",
      size: "xs",
      onClick: togglePopover
    }, getSelectedFilterLabel(filter.dataType)),
    isOpen: isPopoverOpen,
    closePopover: closeTypePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    size: "s",
    initialPanelId: 0,
    panels: [{
      id: 0,
      width: 'auto',
      title: _constants.selectDataViewTypeLabel,
      items: [{
        'data-test-subj': 'logsExplorerDataSourceSelectorDataViewTypeAll',
        icon: !filter.dataType ? 'check' : 'empty',
        name: _constants.allDataViewTypesLabel,
        onClick: createSelectTypeFilter(undefined)
      }, {
        'data-test-subj': 'logsExplorerDataSourceSelectorDataViewTypeLogs',
        icon: filter.dataType === logsDataViewType ? 'check' : 'empty',
        name: _constants.logsDataViewTypeLabel,
        onClick: createSelectTypeFilter(logsDataViewType)
      }]
    }]
  }))));
};
exports.DataViewsFilter = DataViewsFilter;