"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDataButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _routerUtils = require("@kbn/router-utils");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../constants");
var _use_kibana = require("../../../utils/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddDataButton = ({}) => {
  const {
    services: {
      share: {
        url: urlService
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const locator = urlService.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  const onboardingUrl = locator === null || locator === void 0 ? void 0 : locator.useUrl({});
  const navigateToOnboarding = () => {
    locator === null || locator === void 0 ? void 0 : locator.navigate({});
  };
  const onboardingLinkProps = (0, _routerUtils.getRouterLinkProps)({
    href: onboardingUrl,
    onClick: navigateToOnboarding
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "logsExplorerAddDataButtonButton"
  }, onboardingLinkProps, {
    iconType: "plusInCircleFilled",
    size: "xs"
  }), _constants.addDataLabel);
};
exports.AddDataButton = AddDataButton;