"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldContainsData = fieldContainsData;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks if the provided field contains data (works for meta field)
 */
function fieldContainsData(fieldName, indexPattern, hasFieldData) {
  const field = indexPattern.getFieldByName(fieldName);
  return (field === null || field === void 0 ? void 0 : field.type) === 'document' || hasFieldData(indexPattern.id, fieldName);
}