"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messagesToOpenAI = messagesToOpenAI;
exports.toolChoiceToOpenAI = toolChoiceToOpenAI;
exports.toolsToOpenAI = toolsToOpenAI;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toolsToOpenAI(tools) {
  return tools ? Object.entries(tools).map(([toolName, {
    description,
    schema
  }]) => {
    return {
      type: 'function',
      function: {
        name: toolName,
        description,
        parameters: schema !== null && schema !== void 0 ? schema : {
          type: 'object',
          properties: {}
        }
      }
    };
  }) : undefined;
}
function toolChoiceToOpenAI(toolChoice) {
  return typeof toolChoice === 'string' ? toolChoice : toolChoice ? {
    function: {
      name: toolChoice.function
    },
    type: 'function'
  } : undefined;
}
function messagesToOpenAI({
  system,
  messages
}) {
  const systemMessage = system ? {
    role: 'system',
    content: system
  } : undefined;
  return [...(systemMessage ? [systemMessage] : []), ...messages.map(message => {
    var _message$content, _message$toolCalls;
    const role = message.role;
    switch (role) {
      case _inferenceCommon.MessageRole.Assistant:
        const assistantMessage = {
          role: 'assistant',
          content: (_message$content = message.content) !== null && _message$content !== void 0 ? _message$content : '',
          tool_calls: (_message$toolCalls = message.toolCalls) === null || _message$toolCalls === void 0 ? void 0 : _message$toolCalls.map(toolCall => {
            return {
              function: {
                name: toolCall.function.name,
                arguments: 'arguments' in toolCall.function ? JSON.stringify(toolCall.function.arguments) : '{}'
              },
              id: toolCall.toolCallId,
              type: 'function'
            };
          })
        };
        return assistantMessage;
      case _inferenceCommon.MessageRole.User:
        const userMessage = {
          role: 'user',
          content: typeof message.content === 'string' ? message.content : message.content.map(contentPart => {
            if (contentPart.type === 'image') {
              return {
                type: 'image_url',
                image_url: {
                  url: contentPart.source.data
                }
              };
            }
            return {
              text: contentPart.text,
              type: 'text'
            };
          })
        };
        return userMessage;
      case _inferenceCommon.MessageRole.Tool:
        const toolMessage = {
          role: 'tool',
          content: JSON.stringify(message.response),
          tool_call_id: message.toolCallId
        };
        return toolMessage;
    }
  })];
}