"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TokenCountType = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _documentation = require("../../../../../../services/documentation");
var _lib = require("../../../../lib");
var _constants = require("../../../../constants");
var _shared_imports = require("../../../../shared_imports");
var _field_parameters = require("../../field_parameters");
var _edit_field = require("../edit_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultToggleValue = (param, field) => {
  switch (param) {
    case 'analyzer':
    case 'meta':
    case 'boost':
      {
        return field[param] !== undefined && field[param] !== (0, _lib.getFieldConfig)(param).defaultValue;
      }
    case 'null_value':
      {
        return field.null_value !== undefined && field.null_value !== '';
      }
    default:
      return false;
  }
};
const TokenCountType = ({
  field,
  kibanaVersion
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_edit_field.BasicParametersSection, null, /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.tokenCount.analyzerSectionTitle', {
      defaultMessage: 'Analyzer'
    }),
    docLink: {
      text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.tokenCount.analyzerLinkText', {
        defaultMessage: 'Analyzer documentation'
      }),
      href: _documentation.documentationService.getAnalyzerLink()
    },
    withToggle: false
  }, /*#__PURE__*/_react.default.createElement(_field_parameters.AnalyzerParameter, {
    path: "analyzer",
    config: {
      ...(0, _lib.getFieldConfig)('analyzer'),
      defaultValue: _constants.STANDARD
    } // If "field.source.analyzer" is undefined, defaults to "standard" analyzer
    ,
    defaultValue: field.source.analyzer,
    allowsIndexDefaultOption: false
  })), /*#__PURE__*/_react.default.createElement(_field_parameters.IndexParameter, {
    hasIndexOptions: false
  })), /*#__PURE__*/_react.default.createElement(_edit_field.AdvancedParametersSection, null, /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.tokenCount.enablePositionIncrementsFieldTitle', {
      defaultMessage: 'Enable position increments'
    }),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.tokenCount.enablePositionIncrementsFieldDescription', {
      defaultMessage: 'Whether to count position increments.'
    }),
    formFieldPath: "enable_position_increments"
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.DocValuesParameter, null), /*#__PURE__*/_react.default.createElement(_field_parameters.NullValueParameter, {
    defaultToggleValue: getDefaultToggleValue('null_value', field.source),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.tokenCount.nullValueFieldDescription', {
      defaultMessage: 'Accepts a numeric value of the same type as the field which is substituted for any explicit null values.'
    })
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "null_value",
    component: _shared_imports.NumericField,
    config: (0, _lib.getFieldConfig)('null_value_numeric')
  })), /*#__PURE__*/_react.default.createElement(_field_parameters.StoreParameter, null), /*#__PURE__*/_react.default.createElement(_field_parameters.MetaParameter, {
    defaultToggleValue: getDefaultToggleValue('meta', field.source)
  }), kibanaVersion.major < 8 && /*#__PURE__*/_react.default.createElement(_field_parameters.BoostParameter, {
    defaultToggleValue: getDefaultToggleValue('boost', field.source)
  })));
};
exports.TokenCountType = TokenCountType;