"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFieldsMetadataExtractors = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerFieldsMetadataExtractors = ({
  core,
  fieldsMetadata
}) => {
  fieldsMetadata.registerIntegrationFieldsExtractor(async ({
    integration,
    dataset
  }) => {
    const [_core, _startDeps, {
      packageService
    }] = await core.getStartServices();
    return packageService.asInternalUser.getPackageFieldsMetadata({
      packageName: integration,
      datasetName: dataset
    });
  });
  fieldsMetadata.registerIntegrationListExtractor(async () => {
    const [_core, _startDeps, {
      packageService
    }] = await core.getStartServices();
    try {
      const packages = await packageService.asInternalUser.getPackages();
      return packages.map(({
        id,
        name,
        version
      }) => ({
        id,
        name,
        version
      }));
    } catch (error) {
      return [];
    }
  });
};
exports.registerFieldsMetadataExtractors = registerFieldsMetadataExtractors;