"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _types = require("../../types");
var _handler = require("./handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  router.versioned.get({
    path: _constants.FLEET_SERVER_HOST_API_ROUTES.LIST_PATTERN,
    fleetAuthz: authz => {
      return authz.fleet.addAgents || authz.fleet.addFleetServers || authz.fleet.readSettings;
    },
    summary: `Get Fleet Server hosts`,
    options: {
      tags: ['oas-tag:Fleet Server hosts']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetAllFleetServerHostRequestSchema
    }
  }, _handler.getAllFleetServerHostsHandler);
  router.versioned.post({
    path: _constants.FLEET_SERVER_HOST_API_ROUTES.CREATE_PATTERN,
    fleetAuthz: {
      fleet: {
        allSettings: true
      }
    },
    summary: `Create a Fleet Server host`,
    options: {
      tags: ['oas-tag:Fleet Server hosts']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostFleetServerHostRequestSchema
    }
  }, _handler.postFleetServerHost);
  router.versioned.get({
    path: _constants.FLEET_SERVER_HOST_API_ROUTES.INFO_PATTERN,
    fleetAuthz: {
      fleet: {
        readSettings: true
      }
    },
    summary: `Get a Fleet Server host`,
    description: `Get a Fleet Server host by ID.`,
    options: {
      tags: ['oas-tag:Fleet Server hosts']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetOneFleetServerHostRequestSchema
    }
  }, _handler.getFleetServerHostHandler);
  router.versioned.delete({
    path: _constants.FLEET_SERVER_HOST_API_ROUTES.DELETE_PATTERN,
    fleetAuthz: {
      fleet: {
        allSettings: true
      }
    },
    summary: `Delete a Fleet Server host`,
    description: `Delete a Fleet Server host by ID.`,
    options: {
      tags: ['oas-tag:Fleet Server hosts']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetOneFleetServerHostRequestSchema
    }
  }, _handler.deleteFleetServerHostHandler);
  router.versioned.put({
    path: _constants.FLEET_SERVER_HOST_API_ROUTES.UPDATE_PATTERN,
    fleetAuthz: {
      fleet: {
        allSettings: true
      }
    },
    summary: `Update a Fleet Server host`,
    description: `Update a Fleet Server host by ID.`,
    options: {
      tags: ['oas-tag:Fleet Server hosts']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PutFleetServerHostRequestSchema
    }
  }, _handler.putFleetServerHostHandler);
};
exports.registerRoutes = registerRoutes;