"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CompressedInstallationStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CompressedInstallationStatus = ({
  installStatus,
  isActive,
  installedTooltip,
  installFailedTooltip,
  styles
}) => {
  const cardPanelClassNames = (0, _classnames.default)({
    [styles.compressedInstallationStatus]: true,
    [styles.compressedInstalledStatus]: !isActive,
    [styles.compressedActiveStatus]: isActive
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: cardPanelClassNames
  }, isActive ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "data-test-subj": "compressed-active-icon",
    type: "checkInCircleFilled",
    className: styles.compressedActiveStatusIcon
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "compressed-installed-tooltip",
    position: "bottom",
    content: installStatus === 'installed' ? installedTooltip : installFailedTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "data-test-subj": "compressed-installed-icon",
    type: "warningFilled",
    className: styles.compressedInstalledStatusIcon
  })));
};
exports.CompressedInstallationStatus = CompressedInstallationStatus;