"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCrawlerExtractionRulesRoutes = registerCrawlerExtractionRulesRoutes;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractionRuleSchema = _configSchema.schema.object({
  extraction_rule: _configSchema.schema.object({
    description: _configSchema.schema.string(),
    rules: _configSchema.schema.arrayOf(_configSchema.schema.object({
      content_from: _configSchema.schema.object({
        value: _configSchema.schema.nullable(_configSchema.schema.string()),
        value_type: _configSchema.schema.string()
      }),
      field_name: _configSchema.schema.string(),
      multiple_objects_handling: _configSchema.schema.string(),
      selector: _configSchema.schema.string(),
      source_type: _configSchema.schema.string()
    })),
    url_filters: _configSchema.schema.arrayOf(_configSchema.schema.object({
      filter: _configSchema.schema.string(),
      pattern: _configSchema.schema.string()
    }))
  })
});
function registerCrawlerExtractionRulesRoutes({
  router,
  enterpriseSearchRequestHandler
}) {
  router.post({
    path: '/internal/enterprise_search/indices/{indexName}/crawler/domains/{domainId}/extraction_rules',
    validate: {
      body: extractionRuleSchema,
      params: _configSchema.schema.object({
        domainId: _configSchema.schema.string(),
        indexName: _configSchema.schema.string()
      })
    }
  }, enterpriseSearchRequestHandler.createRequest({
    params: {
      respond_with: 'index'
    },
    path: '/api/ent/v1/internal/indices/:indexName/crawler2/domains/:domainId/extraction_rules'
  }));
  router.put({
    path: '/internal/enterprise_search/indices/{indexName}/crawler/domains/{domainId}/extraction_rules/{crawlRuleId}',
    validate: {
      body: extractionRuleSchema,
      params: _configSchema.schema.object({
        crawlRuleId: _configSchema.schema.string(),
        domainId: _configSchema.schema.string(),
        indexName: _configSchema.schema.string()
      })
    }
  }, enterpriseSearchRequestHandler.createRequest({
    params: {
      respond_with: 'index'
    },
    path: '/api/ent/v1/internal/indices/:indexName/crawler2/domains/:domainId/extraction_rules/:crawlRuleId'
  }));
  router.delete({
    path: '/internal/enterprise_search/indices/{indexName}/crawler/domains/{domainId}/extraction_rules/{crawlRuleId}',
    validate: {
      params: _configSchema.schema.object({
        crawlRuleId: _configSchema.schema.string(),
        domainId: _configSchema.schema.string(),
        indexName: _configSchema.schema.string()
      })
    }
  }, enterpriseSearchRequestHandler.createRequest({
    params: {
      respond_with: 'index'
    },
    path: '/api/ent/v1/internal/indices/:indexName/crawler2/domains/:domainId/extraction_rules/:crawlRuleId'
  }));
  router.get({
    path: '/internal/enterprise_search/indices/{indexName}/crawler/domains/{domainId}/extraction_rules/{crawlRuleId}',
    validate: {
      params: _configSchema.schema.object({
        crawlRuleId: _configSchema.schema.string(),
        domainId: _configSchema.schema.string(),
        indexName: _configSchema.schema.string()
      })
    }
  }, enterpriseSearchRequestHandler.createRequest({
    params: {
      respond_with: 'index'
    },
    path: '/api/ent/v1/internal/indices/:indexName/crawler2/domains/:domainId/extraction_rules/:crawlRuleId'
  }));
}