"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchAuthorize = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _flash_messages = require("../../../shared/flash_messages");
var _loading = require("../../../shared/loading");
var _app_logic = require("../../app_logic");
var _search_authorize_logic = require("./search_authorize_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchAuthorize = () => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    initializeSearchAuth
  } = (0, _kea.useActions)(_search_authorize_logic.SearchAuthorizeLogic);
  const {
    searchOAuth
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    redirectPending
  } = (0, _kea.useValues)(_search_authorize_logic.SearchAuthorizeLogic);
  (0, _react.useEffect)(() => {
    if (searchOAuth.clientId) {
      initializeSearchAuth(searchOAuth, search);
    }
  }, [searchOAuth]);
  if (redirectPending) return /*#__PURE__*/_react.default.createElement(_loading.Loading, null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_flash_messages.FlashMessages, null)));
};
exports.SearchAuthorize = SearchAuthorize;