"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceFeatures = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _licensing = require("../../../../../shared/licensing");
var _app_logic = require("../../../../app_logic");
var _types = require("../../../../types");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceFeatures = ({
  features,
  objTypes,
  name
}) => {
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const Feature = ({
    icon,
    title,
    children
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, icon && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: icon
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("strong", null, title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, children));
  };
  const SyncFrequencyFeature = /*#__PURE__*/_react.default.createElement(Feature, {
    icon: "clock",
    title: _constants.SOURCE_FEATURES_SYNC_FREQUENCY_TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.sourceFeatures.syncFrequency.text",
    defaultMessage: "This source gets new content from {name} every {duration} (following the initial sync).",
    values: {
      name,
      duration: /*#__PURE__*/_react.default.createElement("strong", null, _constants.SOURCE_FEATURES_SYNC_FREQUENCY_TIME)
    }
  }))));
  const SyncedItemsFeature = /*#__PURE__*/_react.default.createElement(Feature, {
    icon: "documents",
    title: _constants.SOURCE_FEATURES_SYNCED_ITEMS_TITLE
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _constants.SOURCE_FEATURES_SEARCHABLE_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("ul", null, objTypes.map((objType, i) => /*#__PURE__*/_react.default.createElement("li", {
    key: i
  }, objType))))));
  const SearchableContentFeature = /*#__PURE__*/_react.default.createElement(Feature, {
    icon: "search",
    title: _constants.SOURCE_FEATURES_SEARCHABLE_TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _constants.SOURCE_FEATURES_SEARCHABLE_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("ul", null, objTypes.map((objType, i) => /*#__PURE__*/_react.default.createElement("li", {
    key: i
  }, objType)))));
  const RemoteFeature = /*#__PURE__*/_react.default.createElement(Feature, {
    icon: "calendar",
    title: _constants.SOURCE_FEATURES_REMOTE_FEATURE_TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _constants.SOURCE_FEATURES_REMOTE_FEATURE_DESCRIPTION)));
  const PrivateFeature = /*#__PURE__*/_react.default.createElement(Feature, {
    icon: "lock",
    title: _constants.SOURCE_FEATURES_PRIVATE_FEATURE_TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _constants.SOURCE_FEATURES_PRIVATE_FEATURE_DESCRIPTION)));
  const GlobalAccessPermissionsFeature = /*#__PURE__*/_react.default.createElement(Feature, {
    icon: "globe",
    title: _constants.SOURCE_FEATURES_GLOBAL_ACCESS_PERMISSIONS_FEATURE_TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _constants.SOURCE_FEATURES_GLOBAL_ACCESS_PERMISSIONS_FEATURE_DESCRIPTION)));
  const FeaturesRouter = ({
    featureId
  }) => ({
    [_types.FeatureIds.SyncFrequency]: SyncFrequencyFeature,
    [_types.FeatureIds.SearchableContent]: SearchableContentFeature,
    [_types.FeatureIds.SyncedItems]: SyncedItemsFeature,
    [_types.FeatureIds.Remote]: RemoteFeature,
    [_types.FeatureIds.Private]: PrivateFeature,
    [_types.FeatureIds.GlobalAccessPermissions]: GlobalAccessPermissionsFeature
  })[featureId];
  const IncludedFeatureIds = () => {
    var _includedFeatures;
    let includedFeatures;
    if (!hasPlatinumLicense && isOrganization) {
      includedFeatures = features === null || features === void 0 ? void 0 : features.basicOrgContext;
    }
    if (hasPlatinumLicense && isOrganization) {
      includedFeatures = features === null || features === void 0 ? void 0 : features.platinumOrgContext;
    }
    if (hasPlatinumLicense && !isOrganization) {
      includedFeatures = features === null || features === void 0 ? void 0 : features.platinumPrivateContext;
    }
    if (!((_includedFeatures = includedFeatures) !== null && _includedFeatures !== void 0 && _includedFeatures.length)) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, _constants.INCLUDED_FEATURES_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, includedFeatures.map((featureId, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: i
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      paddingSize: "l"
    }, /*#__PURE__*/_react.default.createElement(FeaturesRouter, {
      featureId: featureId
    }))))));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    className: "adding-a-source__features-list",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(IncludedFeatureIds, null)));
};
exports.SourceFeatures = SourceFeatures;