"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentPermissionsField = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../shared/doc_links");
var _constants = require("../../constants");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentPermissionsField = ({
  needsPermissions,
  indexPermissionsValue,
  setValue
}) => {
  const whichDocsLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.workplaceSearchDocumentPermissions
  }, _constants2.CONNECT_WHICH_OPTION_LINK);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement("strong", null, _constants2.CONNECT_DOC_PERMISSIONS_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, !needsPermissions && /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `needsPermissionText`
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.connect.docPermissionsUnavailable.message",
    defaultMessage: "Document-level permissions are not yet available for this source. {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: _doc_links.docLinks.workplaceSearchDocumentPermissions
      }, _constants.LEARN_MORE_LINK)
    }
  })), needsPermissions && indexPermissionsValue && /*#__PURE__*/_react.default.createElement("span", null, _constants2.CONNECT_NEEDS_PERMISSIONS, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), whichDocsLink)), !indexPermissionsValue && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _constants2.CONNECT_NOT_SYNCED_TITLE,
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, _constants2.CONNECT_NOT_SYNCED_TEXT, needsPermissions && whichDocsLink))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement("strong", null, _constants2.CONNECT_DOC_PERMISSIONS_LABEL),
    name: "index_permissions",
    onChange: e => setValue(e.target.checked),
    checked: indexPermissionsValue,
    disabled: !needsPermissions
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }));
};
exports.DocumentPermissionsField = DocumentPermissionsField;