"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.crawlerStatusToColor = crawlerStatusToColor;
exports.crawlerStatusToText = crawlerStatusToText;
var _i18n = require("@kbn/i18n");
var _constants = require("../components/search_index/crawler/crawl_requests_panel/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function crawlerStatusToText(crawlerStatus) {
  return crawlerStatus ? _constants.readableCrawlerStatuses[crawlerStatus] : _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionStatus.idle.label', {
    defaultMessage: 'Idle'
  });
}
function crawlerStatusToColor(crawlerStatus) {
  return crawlerStatus ? _constants.crawlStatusColors[crawlerStatus] : 'default';
}