"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DESCENDING = exports.ASCENDING = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASCENDING = fieldName => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.sortBy.option.ascendingDropDownOptionLabel', {
  defaultMessage: '{fieldName} (asc)',
  values: {
    fieldName
  }
});
exports.ASCENDING = ASCENDING;
const DESCENDING = fieldName => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.sortBy.option.descendingDropDownOptionLabel', {
  defaultMessage: '{fieldName} (desc)',
  values: {
    fieldName
  }
});
exports.DESCENDING = DESCENDING;