"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntryPointsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../shared/doc_links");
var _generic_endpoint_inline_editable_table = require("../../../../shared/tables/generic_endpoint_inline_editable_table");
var _entry_points_table_logic = require("./entry_points_table_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntryPointsTable = ({
  domain,
  engineName,
  items
}) => {
  const {
    onAdd,
    onDelete,
    onUpdate
  } = (0, _kea.useActions)(_entry_points_table_logic.EntryPointsTableLogic);
  const field = 'value';
  const columns = [{
    editingRender: (entryPoint, onChange, {
      isInvalid,
      isLoading
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: entryPoint[field],
      onChange: e => onChange(e.target.value),
      disabled: isLoading,
      isInvalid: isInvalid,
      prepend: domain.url
    }),
    render: entryPoint => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, domain.url, entryPoint[field]),
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.entryPointsTable.urlTableHead', {
      defaultMessage: 'URL'
    }),
    field
  }];
  const entryPointsRoute = `/internal/app_search/engines/${engineName}/crawler/domains/${domain.id}/entry_points`;
  const getEntryPointRoute = entryPoint => `/internal/app_search/engines/${engineName}/crawler/domains/${domain.id}/entry_points/${entryPoint.id}`;
  return /*#__PURE__*/_react.default.createElement(_generic_endpoint_inline_editable_table.GenericEndpointInlineEditableTable, {
    addButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.entryPointsTable.addButtonLabel', {
      defaultMessage: 'Add entry point'
    }),
    columns: columns,
    description: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.entryPointsTable.description', {
      defaultMessage: 'Include the most important URLs for your website here. Entry point URLs will be the first pages to be indexed and processed for links to other pages.'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.appSearchEntryPoints,
      target: "_blank",
      external: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.entryPointsTable.learnMoreLinkText', {
      defaultMessage: 'Learn more about entry points.'
    }))),
    instanceId: "EntryPointsTable",
    items: items,
    lastItemWarning: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.entryPointsTable.lastItemMessage', {
      defaultMessage: 'The crawler requires at least one entry point.'
    })
    // Since canRemoveLastItem is false, the only time noItemsMessage would be displayed is if the last entry point was deleted via the API.
    ,
    noItemsMessage: editNewItem => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.entryPointsTable.emptyMessageTitle', {
      defaultMessage: 'There are no existing entry points.'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.appSearch.crawler.entryPointsTable.emptyMessageDescription",
      defaultMessage: "{link} to specify an entry point for the crawler",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: editNewItem
        }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.entryPointsTable.emptyMessageLinkText', {
          defaultMessage: 'Add an entry point'
        }))
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)),
    addRoute: entryPointsRoute,
    canRemoveLastItem: false,
    deleteRoute: getEntryPointRoute,
    updateRoute: getEntryPointRoute,
    dataProperty: "entry_points",
    onAdd: onAdd,
    onDelete: onDelete,
    onUpdate: onUpdate,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.entryPointsTable.title', {
      defaultMessage: 'Entry points'
    }),
    disableReordering: true
  });
};
exports.EntryPointsTable = EntryPointsTable;