"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openConfigEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _presentationContainers = require("@kbn/presentation-containers");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _reactQuery = require("@kbn/react-query");
var _query_client = require("../query_client");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const openConfigEditor = async ({
  coreServices,
  parentApi,
  initialConfig
}) => {
  const {
    ConfigEditorFlyout
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./config_editor_flyout')));
  const {
    overlays,
    http,
    notifications,
    ...startServices
  } = coreServices;

  /**
   * If available, the parent API will keep track of which flyout is open and close it
   * if the app changes, disable certain actions when the flyout is open, etc.
   */
  const overlayTracker = (0, _presentationContainers.tracksOverlays)(parentApi) ? parentApi : undefined;
  return new Promise((resolve, reject) => {
    const onSave = newConfig => {
      resolve(newConfig);
      flyoutSession.close();
      overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
    };
    const onCancel = () => {
      reject();
      flyoutSession.close();
      overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
    };
    const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
      client: _query_client.queryClient
    }, /*#__PURE__*/_react.default.createElement(ConfigEditorFlyout, {
      initialConfig: initialConfig,
      onSave: onSave,
      onCancel: onCancel,
      services: {
        http,
        notifications,
        overlays
      }
    })), startServices), {
      onClose: () => {
        onCancel();
      },
      size: 'm',
      maxWidth: 500,
      paddingSize: 'm',
      ownFocus: true,
      'data-test-subj': 'createAlertsTableEmbeddableFlyout'
    });
    overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.openOverlay(flyoutSession);
  });
};
exports.openConfigEditor = openConfigEditor;