"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeTools = executeTools;
var _prebuilt = require("@langchain/langgraph/prebuilt");
var _lodash = require("lodash");
var _utils = require("../../../../../routes/utils");
var _event_based_telemetry = require("../../../../telemetry/event_based_telemetry");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Node to execute tools
 *
 * Note: Could maybe leverage `ToolNode` if tool selection state is pushed to `messages[]`.
 * See: https://github.com/langchain-ai/langgraphjs/blob/0ef76d603b55c00a04f5793d1e6ab15af7c756cb/langgraph/src/prebuilt/tool_node.ts
 *
 * @param logger - The scoped logger
 * @param state - The current state of the graph
 * @param tools - The tools available to execute
 * @param config - Any configuration that may've been supplied
 */
async function executeTools({
  logger,
  state,
  tools,
  config,
  telemetryParams,
  telemetry
}) {
  var _castArray;
  logger.debug(() => `${_constants.NodeType.TOOLS}: Node state:\n${JSON.stringify(state, null, 2)}`);
  const toolExecutor = new _prebuilt.ToolExecutor({
    tools
  });
  const steps = await Promise.all((_castArray = (0, _lodash.castArray)(state.agentOutcome)) === null || _castArray === void 0 ? void 0 : _castArray.map(async action => {
    let out;
    try {
      out = await toolExecutor.invoke(action, config);
    } catch (err) {
      var _telemetryParams$acti, _err$message, _telemetryParams$assi, _telemetryParams$isEn;
      telemetry.reportEvent(_event_based_telemetry.INVOKE_ASSISTANT_ERROR_EVENT.eventType, {
        actionTypeId: (_telemetryParams$acti = telemetryParams === null || telemetryParams === void 0 ? void 0 : telemetryParams.actionTypeId) !== null && _telemetryParams$acti !== void 0 ? _telemetryParams$acti : (0, _utils.getActionTypeId)(state.llmType),
        model: telemetryParams === null || telemetryParams === void 0 ? void 0 : telemetryParams.model,
        errorMessage: (_err$message = err.message) !== null && _err$message !== void 0 ? _err$message : err.toString(),
        assistantStreamingEnabled: (_telemetryParams$assi = telemetryParams === null || telemetryParams === void 0 ? void 0 : telemetryParams.assistantStreamingEnabled) !== null && _telemetryParams$assi !== void 0 ? _telemetryParams$assi : state.isStream,
        isEnabledKnowledgeBase: (_telemetryParams$isEn = telemetryParams === null || telemetryParams === void 0 ? void 0 : telemetryParams.isEnabledKnowledgeBase) !== null && _telemetryParams$isEn !== void 0 ? _telemetryParams$isEn : false,
        errorLocation: `executeTools-${action.tool}`
      });
      return {
        action,
        observation: JSON.stringify(`Error: ${err}`, null, 2)
      };
    }
    return {
      action,
      observation: JSON.stringify(out, null, 2)
    };
  }));
  return {
    steps,
    lastNode: _constants.NodeType.TOOLS
  };
}