"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRetrieveAnonymizedAlertsNode = void 0;
var _anonymized_alerts_retriever = require("./anonymized_alerts_retriever");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRetrieveAnonymizedAlertsNode = ({
  alertsIndexPattern,
  anonymizationFields,
  esClient,
  logger,
  onNewReplacements,
  replacements,
  size
}) => {
  let localReplacements = {
    ...(replacements !== null && replacements !== void 0 ? replacements : {})
  };
  const localOnNewReplacements = newReplacements => {
    localReplacements = {
      ...localReplacements,
      ...newReplacements
    };
    onNewReplacements === null || onNewReplacements === void 0 ? void 0 : onNewReplacements(localReplacements); // invoke the callback with the latest replacements
  };
  const retrieveAnonymizedAlerts = async state => {
    logger === null || logger === void 0 ? void 0 : logger.debug(() => '---RETRIEVE ANONYMIZED ALERTS---');
    const {
      end,
      filter,
      start
    } = state;
    const retriever = new _anonymized_alerts_retriever.AnonymizedAlertsRetriever({
      alertsIndexPattern,
      anonymizationFields,
      end,
      esClient,
      filter,
      onNewReplacements: localOnNewReplacements,
      replacements,
      size,
      start
    });
    const documents = await retriever.withConfig({
      runName: 'runAnonymizedAlertsRetriever'
    }).invoke('');
    return {
      ...state,
      anonymizedAlerts: documents,
      replacements: localReplacements
    };
  };
  return retrieveAnonymizedAlerts;
};
exports.getRetrieveAnonymizedAlertsNode = getRetrieveAnonymizedAlertsNode;