"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldUsageEventName = exports.DiscoverEBTManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _profiles_manager = require("../context_awareness/profiles_manager");
var _discover_ebt_manager_registrations = require("./discover_ebt_manager_registrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let FieldUsageEventName = exports.FieldUsageEventName = /*#__PURE__*/function (FieldUsageEventName) {
  FieldUsageEventName["dataTableSelection"] = "dataTableSelection";
  FieldUsageEventName["dataTableRemoval"] = "dataTableRemoval";
  FieldUsageEventName["filterAddition"] = "filterAddition";
  return FieldUsageEventName;
}({});
class DiscoverEBTManager {
  constructor() {
    (0, _defineProperty2.default)(this, "isCustomContextEnabled", false);
    (0, _defineProperty2.default)(this, "customContext$", void 0);
    (0, _defineProperty2.default)(this, "reportEvent", void 0);
    (0, _defineProperty2.default)(this, "lastResolvedContextProfiles", void 0);
    this.lastResolvedContextProfiles = {
      [_profiles_manager.ContextualProfileLevel.rootLevel]: undefined,
      [_profiles_manager.ContextualProfileLevel.dataSourceLevel]: undefined,
      [_profiles_manager.ContextualProfileLevel.documentLevel]: undefined
    };
  }

  // https://docs.elastic.dev/telemetry/collection/event-based-telemetry
  initialize({
    core,
    discoverEbtContext$
  }) {
    this.customContext$ = discoverEbtContext$;
    this.reportEvent = core.analytics.reportEvent;
  }
  onDiscoverAppMounted() {
    this.isCustomContextEnabled = true;
  }
  onDiscoverAppUnmounted() {
    this.updateProfilesContextWith([]);
    this.isCustomContextEnabled = false;
    this.lastResolvedContextProfiles = {
      [_profiles_manager.ContextualProfileLevel.rootLevel]: undefined,
      [_profiles_manager.ContextualProfileLevel.dataSourceLevel]: undefined,
      [_profiles_manager.ContextualProfileLevel.documentLevel]: undefined
    };
  }
  updateProfilesContextWith(discoverProfiles) {
    if (this.isCustomContextEnabled && this.customContext$ && !(0, _lodash.isEqual)(this.customContext$.getValue().discoverProfiles, discoverProfiles)) {
      this.customContext$.next({
        discoverProfiles
      });
    }
  }
  getProfilesContext() {
    var _this$customContext$, _this$customContext$$;
    return (_this$customContext$ = this.customContext$) === null || _this$customContext$ === void 0 ? void 0 : (_this$customContext$$ = _this$customContext$.getValue()) === null || _this$customContext$$ === void 0 ? void 0 : _this$customContext$$.discoverProfiles;
  }
  async trackFieldUsageEvent({
    eventName,
    fieldName,
    filterOperation,
    fieldsMetadata
  }) {
    if (!this.reportEvent) {
      return;
    }
    const eventData = {
      [_discover_ebt_manager_registrations.FIELD_USAGE_EVENT_NAME]: eventName
    };
    if (fieldsMetadata) {
      var _fields$fieldName;
      const client = await fieldsMetadata.getClient();
      const {
        fields
      } = await client.find({
        attributes: ['short'],
        fieldNames: [fieldName]
      });

      // excludes non ECS fields
      if ((_fields$fieldName = fields[fieldName]) !== null && _fields$fieldName !== void 0 && _fields$fieldName.short) {
        eventData[_discover_ebt_manager_registrations.FIELD_USAGE_FIELD_NAME] = fieldName;
      }
    }
    if (filterOperation) {
      eventData[_discover_ebt_manager_registrations.FIELD_USAGE_FILTER_OPERATION] = filterOperation;
    }
    this.reportEvent(_discover_ebt_manager_registrations.FIELD_USAGE_EVENT_TYPE, eventData);
  }
  async trackDataTableSelection({
    fieldName,
    fieldsMetadata
  }) {
    await this.trackFieldUsageEvent({
      eventName: FieldUsageEventName.dataTableSelection,
      fieldName,
      fieldsMetadata
    });
  }
  async trackDataTableRemoval({
    fieldName,
    fieldsMetadata
  }) {
    await this.trackFieldUsageEvent({
      eventName: FieldUsageEventName.dataTableRemoval,
      fieldName,
      fieldsMetadata
    });
  }
  async trackFilterAddition({
    fieldName,
    fieldsMetadata,
    filterOperation
  }) {
    await this.trackFieldUsageEvent({
      eventName: FieldUsageEventName.filterAddition,
      fieldName,
      fieldsMetadata,
      filterOperation
    });
  }
  trackContextualProfileResolvedEvent({
    contextLevel,
    profileId
  }) {
    if (!this.reportEvent) {
      return;
    }
    if (this.lastResolvedContextProfiles[contextLevel] === profileId) {
      // avoid sending duplicate events to EBT
      return;
    }
    this.lastResolvedContextProfiles[contextLevel] = profileId;
    const eventData = {
      [_discover_ebt_manager_registrations.CONTEXTUAL_PROFILE_LEVEL]: contextLevel,
      [_discover_ebt_manager_registrations.CONTEXTUAL_PROFILE_ID]: profileId
    };
    this.reportEvent(_discover_ebt_manager_registrations.CONTEXTUAL_PROFILE_RESOLVED_EVENT_TYPE, eventData);
  }
}
exports.DiscoverEBTManager = DiscoverEBTManager;